/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec;

import com.emc.codec.Decoder;
import com.emc.codec.EncodeInputStream;
import com.emc.codec.EncodeMetadata;
import com.emc.codec.EncodeOutputStream;
import com.emc.codec.Encoder;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public abstract class AbstractCodec<M extends EncodeMetadata>
implements Encoder<M>,
Decoder<M>,
Comparable<AbstractCodec<M>> {
    @Override
    public boolean canEncode(String encodeSpec) {
        return this.canProcess(encodeSpec);
    }

    @Override
    public boolean canDecode(String encodeSpec) {
        return this.canProcess(encodeSpec);
    }

    protected abstract boolean canProcess(String var1);

    @Override
    public long getEncodedSize(long originalSize, Map<String, Object> codecProperties) {
        return this.getEncodedSize(originalSize, this.getDefaultEncodeSpec(), codecProperties);
    }

    @Override
    public EncodeOutputStream<M> getEncodingStream(OutputStream originalStream, Map<String, Object> codecProperties) {
        return this.getEncodingStream(originalStream, this.getDefaultEncodeSpec(), codecProperties);
    }

    @Override
    public EncodeInputStream<M> getEncodingStream(InputStream originalStream, Map<String, Object> codecProperties) {
        return this.getEncodingStream(originalStream, this.getDefaultEncodeSpec(), codecProperties);
    }

    @Override
    public int compareTo(AbstractCodec<M> o) {
        return this.getPriority() - o.getPriority();
    }
}

