/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.util;

import com.emc.object.util.ChecksumError;
import com.emc.object.util.ChecksumValue;
import com.emc.object.util.RunningChecksum;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;

public class ChecksummedInputStream
extends InputStream {
    private InputStream delegate;
    private RunningChecksum checksum;
    private ChecksumValue verifyChecksum;

    public ChecksummedInputStream(InputStream delegate, ChecksumValue verifyChecksum) throws NoSuchAlgorithmException {
        this(delegate, new RunningChecksum(verifyChecksum.getAlgorithm()));
        this.verifyChecksum = verifyChecksum;
    }

    public ChecksummedInputStream(InputStream delegate, RunningChecksum checksum) {
        this.delegate = delegate;
        this.checksum = checksum;
    }

    @Override
    public int read() throws IOException {
        byte[] single = new byte[1];
        return this.read(single) == -1 ? -1 : single[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int value = this.delegate.read(b, off, len);
        if (value < 0) {
            this.finish();
        } else {
            this.update(b, off, value);
        }
        return value;
    }

    @Override
    public long skip(long n) throws IOException {
        int toSkip;
        long remaining;
        int skipped;
        for (remaining = n; remaining > 0L && (skipped = this.skip(toSkip = (int)Math.min(remaining, Integer.MAX_VALUE))) != 0; remaining -= (long)skipped) {
        }
        return n - remaining;
    }

    private int skip(int n) throws IOException {
        int total;
        int read;
        byte[] bytes = new byte[65536];
        for (total = 0; total < n; total += read) {
            int toRead = Math.min(n - total, bytes.length);
            read = this.delegate.read(bytes, 0, toRead);
            if (read < 0) {
                this.finish();
                break;
            }
            this.update(bytes, 0, read);
        }
        return total;
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readLimit) {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public ChecksumValue getChecksum() {
        return this.checksum;
    }

    private void update(byte[] bytes, int offset, int length) {
        this.checksum.update(bytes, offset, length);
    }

    private void finish() {
        String calculatedValue;
        String referenceValue;
        if (this.verifyChecksum != null && !(referenceValue = this.verifyChecksum.getHexValue()).equals(calculatedValue = this.checksum.getHexValue())) {
            throw new ChecksumError("Checksum failure while reading stream", referenceValue, calculatedValue);
        }
    }
}

