/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Config;
import com.emc.object.s3.S3Exception;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryFilter
extends ClientFilter {
    private static final Logger log = LoggerFactory.getLogger(RetryFilter.class);
    public static final String PROP_RETRY_COUNT = "com.emc.object.retryCount";
    private S3Config s3Config;

    public RetryFilter(S3Config s3Config) {
        this.s3Config = s3Config;
    }

    public ClientResponse handle(ClientRequest clientRequest) throws ClientHandlerException {
        int retryCount = 0;
        InputStream entityStream = null;
        if (clientRequest.getEntity() instanceof InputStream) {
            entityStream = (InputStream)clientRequest.getEntity();
        }
        while (true) {
            try {
                if (entityStream != null && entityStream.markSupported()) {
                    entityStream.mark(this.s3Config.getRetryBufferSize());
                }
                return this.getNext().handle(clientRequest);
            }
            catch (RuntimeException orig) {
                S3Exception se;
                Throwable t = orig;
                if (t instanceof ClientHandlerException) {
                    t = t.getCause();
                }
                if (t instanceof S3Exception ? (se = (S3Exception)t).getHttpCode() < 500 || se.getHttpCode() == 501 : !(t instanceof IOException)) {
                    throw orig;
                }
                if (++retryCount > this.s3Config.getRetryLimit()) {
                    throw orig;
                }
                if (entityStream != null) {
                    try {
                        if (!entityStream.markSupported()) {
                            throw new IOException("stream does not support mark/reset");
                        }
                        entityStream.reset();
                    }
                    catch (IOException e) {
                        log.warn("could not reset entity stream for retry: " + e);
                        throw orig;
                    }
                }
                if (this.s3Config.getInitialRetryDelay() > 0) {
                    int retryDelay = this.s3Config.getInitialRetryDelay() * (int)Math.pow(2.0, retryCount - 1);
                    try {
                        log.debug("waiting {}ms before retry", (Object)retryDelay);
                        Thread.sleep(retryDelay);
                    }
                    catch (InterruptedException e) {
                        log.warn("interrupted while waiting to retry: " + e.getMessage());
                    }
                }
                log.info("error received in response [{}], retrying ({} of {})...", new Object[]{t, retryCount, this.s3Config.getRetryLimit()});
                clientRequest.getProperties().put(PROP_RETRY_COUNT, retryCount);
                continue;
            }
            break;
        }
    }
}

