/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.bean;

import com.emc.object.s3.bean.CanonicalUser;
import com.emc.object.s3.bean.Grant;
import com.emc.object.s3.bean.Group;
import com.emc.object.util.RestUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="AccessControlPolicy")
@XmlType(propOrder={"owner", "grants"})
@XmlSeeAlso(value={CanonicalUser.class, Group.class})
public class AccessControlList {
    private CanonicalUser owner;
    private Set<Grant> grants = new LinkedHashSet<Grant>();

    @XmlElement(name="Owner")
    public CanonicalUser getOwner() {
        return this.owner;
    }

    public void setOwner(CanonicalUser owner) {
        this.owner = owner;
    }

    @XmlElementWrapper(name="AccessControlList")
    @XmlElement(name="Grant")
    public Set<Grant> getGrants() {
        return this.grants;
    }

    public void setGrants(Set<Grant> grants) {
        this.grants = grants;
    }

    public void addGrants(Grant ... grants) {
        this.grants.addAll(Arrays.asList(grants));
    }

    public Map<String, List<Object>> toHeaders() {
        HashMap<String, List<Object>> headers = new HashMap<String, List<Object>>();
        for (Grant grant : this.grants) {
            RestUtil.add(headers, grant.getPermission().getHeaderName(), grant.getGrantee().getHeaderValue());
        }
        return headers;
    }
}

