/*
 * Decompiled with CFR 0.152.
 */
package com.effective.android.panel.view.panel;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Pair;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.effective.android.panel.interfaces.ViewAssertion;
import com.effective.android.panel.view.panel.IPanelView;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\b\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB+\b\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\bJ\u0010\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\bJ\"\u0010\u001a\u001a\u00020\u00132\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0014J0\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0014J.\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0$2\u0006\u0010\u0019\u001a\u00020\b2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0$R*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Lcom/effective/android/panel/view/panel/PanelContainer;", "Landroid/widget/FrameLayout;", "Lcom/effective/android/panel/interfaces/ViewAssertion;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "<set-?>", "Landroid/util/SparseArray;", "Lcom/effective/android/panel/view/panel/IPanelView;", "panelSparseArray", "getPanelSparseArray", "()Landroid/util/SparseArray;", "assertView", "", "changeContainerHeight", "targetHeight", "getPanelId", "panel", "getPanelView", "panelId", "initView", "onFinishInflate", "onLayout", "changed", "", "left", "top", "right", "bottom", "showPanel", "Landroid/util/Pair;", "size", "panel_release"})
public final class PanelContainer
extends FrameLayout
implements ViewAssertion {
    @NotNull
    private SparseArray<IPanelView> panelSparseArray;
    private HashMap _$_findViewCache;

    @NotNull
    public final SparseArray<IPanelView> getPanelSparseArray() {
        return this.panelSparseArray;
    }

    private final void initView(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.assertView();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void assertView() {
        this.panelSparseArray = new SparseArray();
        int n = 0;
        int n2 = this.getChildCount();
        while (n < n2) {
            IPanelView panel;
            void i;
            View view = this.getChildAt((int)i);
            if (!(view instanceof IPanelView)) {
                view = null;
            }
            if ((IPanelView)view == null) {
                throw (Throwable)new RuntimeException("PanelContainer -- PanelContainer's child should be IPanelView");
            }
            this.panelSparseArray.put(panel.getBindingTriggerViewId(), (Object)panel);
            IPanelView iPanelView = panel;
            if (iPanelView == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.View");
            }
            ((View)iPanelView).setVisibility(8);
            ++i;
        }
    }

    @Nullable
    public final IPanelView getPanelView(int panelId) {
        return (IPanelView)this.panelSparseArray.get(panelId);
    }

    public final int getPanelId(@Nullable IPanelView panel) {
        IPanelView iPanelView = panel;
        return iPanelView != null ? iPanelView.getBindingTriggerViewId() : 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Integer, Integer> showPanel(int panelId, @NotNull Pair<Integer, Integer> size) {
        Intrinsics.checkParameterIsNotNull(size, (String)"size");
        IPanelView panel = (IPanelView)this.panelSparseArray.get(panelId);
        int n = 0;
        int n2 = this.panelSparseArray.size();
        while (n < n2) {
            void i;
            IPanelView panelView = (IPanelView)this.panelSparseArray.get(this.panelSparseArray.keyAt((int)i));
            if (panelView instanceof View) {
                ((View)panelView).setVisibility(Intrinsics.areEqual((Object)panelView, (Object)panel) ^ true ? 8 : 0);
            }
            ++i;
        }
        IPanelView iPanelView = panel;
        if (iPanelView == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.View");
        }
        ViewGroup.LayoutParams layoutParams = ((View)iPanelView).getLayoutParams();
        Pair curSize = new Pair((Object)layoutParams.width, (Object)layoutParams.height);
        if (Intrinsics.areEqual((Object)((Integer)curSize.first), (Object)((Integer)size.first)) ^ true || Intrinsics.areEqual((Object)((Integer)curSize.second), (Object)((Integer)size.second)) ^ true) {
            Object object = size.first;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"size.first");
            layoutParams.width = ((Number)object).intValue();
            Object object2 = size.second;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"size.second");
            layoutParams.height = ((Number)object2).intValue();
            ((View)panel).setLayoutParams(layoutParams);
        }
        return curSize;
    }

    public final void changeContainerHeight(int targetHeight) {
        if (this.getLayoutParams() != null && this.getLayoutParams().height != targetHeight) {
            this.getLayoutParams().height = targetHeight;
        }
    }

    @JvmOverloads
    public PanelContainer(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Context context2 = context;
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        super(context2, attrs, defStyleAttr);
        this.panelSparseArray = new SparseArray();
        this.initView(attrs, defStyleAttr, 0);
    }

    public /* synthetic */ PanelContainer(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public PanelContainer(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PanelContainer(@Nullable Context context) {
        this(context, null, 0, 6, null);
    }

    @TargetApi(value=21)
    public PanelContainer(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Context context2 = context;
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        super(context2, attrs, defStyleAttr, defStyleRes);
        this.panelSparseArray = new SparseArray();
        this.initView(attrs, defStyleAttr, defStyleRes);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

