/*
 * Decompiled with CFR 0.152.
 */
package com.effective.android.panel.log;

import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.effective.android.panel.Constants;
import com.effective.android.panel.interfaces.listener.OnEditFocusChangeListener;
import com.effective.android.panel.interfaces.listener.OnKeyboardStateListener;
import com.effective.android.panel.interfaces.listener.OnPanelChangeListener;
import com.effective.android.panel.interfaces.listener.OnViewClickListener;
import com.effective.android.panel.view.panel.IPanelView;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0007J\u0012\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\u0012\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J:\u0010\u001b\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/effective/android/panel/log/LogTracker;", "Lcom/effective/android/panel/interfaces/listener/OnEditFocusChangeListener;", "Lcom/effective/android/panel/interfaces/listener/OnKeyboardStateListener;", "Lcom/effective/android/panel/interfaces/listener/OnPanelChangeListener;", "Lcom/effective/android/panel/interfaces/listener/OnViewClickListener;", "()V", "TAG", "", "log", "", "methodName", "message", "onClickBefore", "view", "Landroid/view/View;", "onFocusChange", "hasFocus", "", "onKeyboard", "onKeyboardChange", "show", "height", "", "onNone", "onPanel", "panel", "Lcom/effective/android/panel/view/panel/IPanelView;", "onPanelSizeChange", "portrait", "oldWidth", "oldHeight", "width", "panel_release"})
public final class LogTracker
implements OnEditFocusChangeListener,
OnKeyboardStateListener,
OnPanelChangeListener,
OnViewClickListener {
    private static final String TAG;
    public static final LogTracker INSTANCE;

    @JvmStatic
    public static final void log(@NotNull String methodName, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (TextUtils.isEmpty((CharSequence)methodName) || TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (Constants.DEBUG) {
            Log.d((String)TAG, (String)(methodName + " => " + message));
        }
    }

    @Override
    public void onFocusChange(@Nullable View view, boolean hasFocus) {
        LogTracker.log("OnEditFocusChangeListener#onFocusChange", "EditText has focus ( " + hasFocus + " )");
    }

    @Override
    public void onKeyboardChange(boolean show, int height) {
        LogTracker.log("OnKeyboardStateListener#onKeyboardChange", "Keyboard is showing ( " + show + " ),height is " + height);
    }

    @Override
    public void onKeyboard() {
        LogTracker.log("OnPanelChangeListener#onKeyboard", "panel\uff1a keyboard");
    }

    @Override
    public void onNone() {
        LogTracker.log("OnPanelChangeListener#onNone", "panel\uff1a none");
    }

    @Override
    public void onPanel(@Nullable IPanelView panel) {
        StringBuilder stringBuilder = new StringBuilder().append("panel\uff1a");
        Object object = panel;
        if (object == null || (object = object.toString()) == null) {
            object = "null";
        }
        LogTracker.log("OnPanelChangeListener#onPanel", stringBuilder.append(object).toString());
    }

    @Override
    public void onPanelSizeChange(@Nullable IPanelView panel, boolean portrait, int oldWidth, int oldHeight, int width, int height) {
        StringBuilder stringBuilder = new StringBuilder().append("panelView is ");
        Object object = panel;
        if (object == null || (object = object.toString()) == null) {
            object = "null portrait : " + portrait + " oldWidth : " + oldWidth + " oldHeight : " + oldHeight + " width : " + width + " height : " + height;
        }
        LogTracker.log("OnPanelChangeListener#onPanelSizeChange", stringBuilder.append(object).toString());
    }

    @Override
    public void onClickBefore(@Nullable View view) {
        StringBuilder stringBuilder = new StringBuilder().append("view is ");
        Object object = view;
        if (object == null || (object = object.toString()) == null) {
            object = " null ";
        }
        LogTracker.log("OnViewClickListener#onViewClick", stringBuilder.append(object).toString());
    }

    private LogTracker() {
    }

    static {
        LogTracker logTracker;
        INSTANCE = logTracker = new LogTracker();
        String string = LogTracker.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LogTracker::class.java.simpleName");
        TAG = string;
    }
}

