/*
 * Decompiled with CFR 0.152.
 */
package com.effective.android.panel.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import com.effective.android.panel.R;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\bJ\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010#\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010$\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006&"}, d2={"Lcom/effective/android/panel/utils/DisplayUtil;", "", "()V", "contentViewCanDrawStatusBarArea", "", "window", "Landroid/view/Window;", "dip2px", "", "context", "Landroid/content/Context;", "dipValue", "", "getContentViewHeight", "getInternalDimensionSize", "res", "Landroid/content/res/Resources;", "key", "", "getLocationOnScreen", "", "view", "Landroid/view/View;", "getNavigationBarHeight", "getScreenHeightWithSystemUI", "getScreenHeightWithoutNavigationBar", "getScreenHeightWithoutSystemUI", "getScreenRealHeight", "getStatusBarHeight", "getToolbarHeight", "hasSystemUIFlag", "flag", "isFullScreen", "activity", "Landroid/app/Activity;", "isNavBarVisible", "isNavigationBarShow", "isPortrait", "panel-androidx_release"})
public final class DisplayUtil {
    public static final DisplayUtil INSTANCE;

    @JvmStatic
    public static final int getToolbarHeight(@NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        View view = window.getDecorView().findViewById(0x1020002);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"window.decorView.findVie\u2026indow.ID_ANDROID_CONTENT)");
        return view.getTop();
    }

    @JvmStatic
    @NotNull
    public static final int[] getLocationOnScreen(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        int[] contentViewLocationInScreen = new int[2];
        view.getLocationOnScreen(contentViewLocationInScreen);
        return contentViewLocationInScreen;
    }

    @JvmStatic
    public static final boolean contentViewCanDrawStatusBarArea(@NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        View view = window.getDecorView().findViewById(0x1020002);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"window.decorView.findVie\u2026indow.ID_ANDROID_CONTENT)");
        return DisplayUtil.getLocationOnScreen(view)[1] == 0;
    }

    @JvmStatic
    public static final int getContentViewHeight(@NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        View view = window.getDecorView().findViewById(0x1020002);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"window.decorView.findVie\u2026indow.ID_ANDROID_CONTENT)");
        return view.getHeight();
    }

    public final int getScreenRealHeight(@NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        if (Build.VERSION.SDK_INT >= 17) {
            Object object = window.getContext().getSystemService("window");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager wm = (WindowManager)object;
            DisplayMetrics outMetrics = new DisplayMetrics();
            wm.getDefaultDisplay().getRealMetrics(outMetrics);
            return outMetrics.heightPixels;
        }
        return DisplayUtil.getScreenHeightWithSystemUI(window);
    }

    @JvmStatic
    public static final int getScreenHeightWithSystemUI(@NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        View view = window.getDecorView();
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"window.decorView");
        return view.getHeight();
    }

    @JvmStatic
    public static final int getScreenHeightWithoutNavigationBar(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().heightPixels;
    }

    @JvmStatic
    public static final int getScreenHeightWithoutSystemUI(@NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        Rect r = new Rect();
        window.getDecorView().getWindowVisibleDisplayFrame(r);
        return r.bottom - r.top;
    }

    @JvmStatic
    public static final boolean isFullScreen(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
        return (window.getAttributes().flags & 0x400) == 1024;
    }

    @JvmStatic
    public static final boolean isFullScreen(@NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        return (window.getAttributes().flags & 0x400) == 1024;
    }

    @JvmStatic
    public static final int getStatusBarHeight(@NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        Rect frame = new Rect();
        window.getDecorView().getWindowVisibleDisplayFrame(frame);
        return frame.top;
    }

    @JvmStatic
    public static final int getNavigationBarHeight(@NotNull Context context, @NotNull Window window) {
        String manufacturer;
        String $this$trim$iv;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        int deviceNavigationHeight = INSTANCE.getInternalDimensionSize(resources, "navigation_bar_height");
        if (Build.MANUFACTURER == null) {
            string = "";
        } else {
            String string2 = Build.MANUFACTURER;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Build.MANUFACTURER");
            $this$trim$iv = string2;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }
        $this$trim$iv = manufacturer = string;
        boolean bl = false;
        String string3 = $this$trim$iv;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"samsung", (boolean)false, (int)2, null) && Build.VERSION.SDK_INT >= 28 && Build.VERSION.SDK_INT < 29) {
            View view = window.getDecorView();
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"window.decorView");
            WindowInsets windowInsets = view.getRootWindowInsets();
            Intrinsics.checkExpressionValueIsNotNull((Object)windowInsets, (String)"window.decorView.rootWindowInsets");
            int stableBottom = windowInsets.getStableInsetBottom();
            if (stableBottom < deviceNavigationHeight) {
                return stableBottom;
            }
        }
        return deviceNavigationHeight;
    }

    private final int getInternalDimensionSize(Resources res, String key) {
        int result = 0;
        int resourceId = res.getIdentifier(key, "dimen", "android");
        if (resourceId > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    @JvmStatic
    public static final boolean isPortrait(@NotNull Context context) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        switch (resources.getConfiguration().orientation) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            default: {
                Object object = context.getSystemService("window");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
                }
                Display display = ((WindowManager)object).getDefaultDisplay();
                Point point = new Point();
                display.getSize(point);
                bl = point.x <= point.y;
            }
        }
        return bl;
    }

    @JvmStatic
    @TargetApi(value=14)
    public static final boolean isNavigationBarShow(@NotNull Context context, @NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        return DisplayUtil.isNavBarVisible(context, window);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isNavBarVisible(@NotNull Context context, @NotNull Window window) {
        boolean bl;
        ViewGroup viewGroup;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        boolean isVisible = false;
        ViewGroup viewGroup2 = viewGroup = (ViewGroup)window.getDecorView();
        if (viewGroup2 != null) {
            int id2;
            ViewGroup viewGroup3 = viewGroup2;
            boolean bl2 = false;
            bl = false;
            ViewGroup it = viewGroup3;
            boolean bl3 = false;
            int n = 0;
            int n2 = it.getChildCount();
            while (n < n2) {
                String resourceEntryName;
                void i;
                View view = it.getChildAt((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it.getChildAt(i)");
                id2 = view.getId();
                if (id2 != -1 && Intrinsics.areEqual((Object)"navigationBarBackground", (Object)(resourceEntryName = context.getResources().getResourceEntryName(id2)))) {
                    View view2 = it.getChildAt((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"it.getChildAt(i)");
                    if (view2.getVisibility() == 0) {
                        isVisible = true;
                    }
                }
                ++i;
            }
            if (!isVisible) {
                View navigationBarView;
                View view = navigationBarView = it.findViewById(R.id.immersion_navigation_bar_view);
                if (view != null) {
                    View view3 = view;
                    id2 = 0;
                    boolean resourceEntryName = false;
                    View navigationBar = view3;
                    boolean bl4 = false;
                    if (navigationBar.getVisibility() == 0) {
                        isVisible = true;
                    }
                }
            }
        }
        if (isVisible) {
            String manufacturer;
            String string;
            if (Build.MANUFACTURER == null) {
                string = "";
            } else {
                String string2 = Build.MANUFACTURER;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Build.MANUFACTURER");
                String $this$trim$iv = string2;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl5 = false;
                    boolean bl6 = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            }
            String string3 = manufacturer = string;
            bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"samsung", (boolean)false, (int)2, null) && Build.VERSION.SDK_INT >= 17 && Build.VERSION.SDK_INT < 29) {
                try {
                    return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_hide_bar_enabled") == 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            isVisible = !INSTANCE.hasSystemUIFlag(window, 2);
        }
        return isVisible;
    }

    @JvmStatic
    public static final int dip2px(@NotNull Context context, float dipValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float scale = resources.getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public final boolean hasSystemUIFlag(@NotNull Window window, int flag) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        View view = window.getDecorView();
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"window.decorView");
        return (view.getSystemUiVisibility() & flag) == flag;
    }

    private DisplayUtil() {
    }

    static {
        DisplayUtil displayUtil;
        INSTANCE = displayUtil = new DisplayUtil();
    }
}

