/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1.status;

import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.json.GsonFactory;
import com.ecwid.consul.transport.HttpResponse;
import com.ecwid.consul.transport.TLSConfig;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.OperationException;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.status.StatusClient;
import com.google.gson.reflect.TypeToken;
import java.util.List;

public final class StatusConsulClient
implements StatusClient {
    private final ConsulRawClient rawClient;

    public StatusConsulClient(ConsulRawClient rawClient) {
        this.rawClient = rawClient;
    }

    public StatusConsulClient() {
        this(new ConsulRawClient());
    }

    public StatusConsulClient(TLSConfig tlsConfig) {
        this(new ConsulRawClient(tlsConfig));
    }

    public StatusConsulClient(String agentHost) {
        this(new ConsulRawClient(agentHost));
    }

    public StatusConsulClient(String agentHost, TLSConfig tlsConfig) {
        this(new ConsulRawClient(agentHost, tlsConfig));
    }

    public StatusConsulClient(String agentHost, int agentPort) {
        this(new ConsulRawClient(agentHost, agentPort));
    }

    public StatusConsulClient(String agentHost, int agentPort, TLSConfig tlsConfig) {
        this(new ConsulRawClient(agentHost, agentPort, tlsConfig));
    }

    @Override
    public Response<String> getStatusLeader() {
        HttpResponse httpResponse = this.rawClient.makeGetRequest("/v1/status/leader", new UrlParameters[0]);
        if (httpResponse.getStatusCode() == 200) {
            String value = (String)GsonFactory.getGson().fromJson(httpResponse.getContent(), String.class);
            return new Response<String>(value, httpResponse);
        }
        throw new OperationException(httpResponse);
    }

    @Override
    public Response<List<String>> getStatusPeers() {
        HttpResponse httpResponse = this.rawClient.makeGetRequest("/v1/status/peers", new UrlParameters[0]);
        if (httpResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(httpResponse.getContent(), new TypeToken<List<String>>(){}.getType());
            return new Response<List<String>>(value, httpResponse);
        }
        throw new OperationException(httpResponse);
    }
}

