/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1;

import com.ecwid.consul.transport.TLSConfig;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.acl.AclClient;
import com.ecwid.consul.v1.acl.AclConsulClient;
import com.ecwid.consul.v1.acl.model.Acl;
import com.ecwid.consul.v1.acl.model.NewAcl;
import com.ecwid.consul.v1.acl.model.UpdateAcl;
import com.ecwid.consul.v1.agent.AgentClient;
import com.ecwid.consul.v1.agent.AgentConsulClient;
import com.ecwid.consul.v1.agent.model.Member;
import com.ecwid.consul.v1.agent.model.NewCheck;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.agent.model.Self;
import com.ecwid.consul.v1.agent.model.Service;
import com.ecwid.consul.v1.catalog.CatalogClient;
import com.ecwid.consul.v1.catalog.CatalogConsulClient;
import com.ecwid.consul.v1.catalog.model.CatalogDeregistration;
import com.ecwid.consul.v1.catalog.model.CatalogNode;
import com.ecwid.consul.v1.catalog.model.CatalogRegistration;
import com.ecwid.consul.v1.catalog.model.CatalogService;
import com.ecwid.consul.v1.catalog.model.Node;
import com.ecwid.consul.v1.event.EventClient;
import com.ecwid.consul.v1.event.EventConsulClient;
import com.ecwid.consul.v1.event.model.Event;
import com.ecwid.consul.v1.event.model.EventParams;
import com.ecwid.consul.v1.health.HealthClient;
import com.ecwid.consul.v1.health.HealthConsulClient;
import com.ecwid.consul.v1.health.model.Check;
import com.ecwid.consul.v1.health.model.HealthService;
import com.ecwid.consul.v1.kv.KeyValueClient;
import com.ecwid.consul.v1.kv.KeyValueConsulClient;
import com.ecwid.consul.v1.kv.model.GetBinaryValue;
import com.ecwid.consul.v1.kv.model.GetValue;
import com.ecwid.consul.v1.kv.model.PutParams;
import com.ecwid.consul.v1.session.SessionClient;
import com.ecwid.consul.v1.session.SessionConsulClient;
import com.ecwid.consul.v1.session.model.NewSession;
import com.ecwid.consul.v1.session.model.Session;
import com.ecwid.consul.v1.status.StatusClient;
import com.ecwid.consul.v1.status.StatusConsulClient;
import java.util.List;
import java.util.Map;

public final class ConsulClient
implements AclClient,
AgentClient,
CatalogClient,
EventClient,
HealthClient,
KeyValueClient,
SessionClient,
StatusClient {
    private final AclClient aclClient;
    private final AgentClient agentClient;
    private final CatalogClient catalogClient;
    private final EventClient eventClient;
    private final HealthClient healthClient;
    private final KeyValueClient keyValueClient;
    private final SessionClient sessionClient;
    private final StatusClient statusClient;

    public ConsulClient(ConsulRawClient rawClient) {
        this.aclClient = new AclConsulClient(rawClient);
        this.agentClient = new AgentConsulClient(rawClient);
        this.catalogClient = new CatalogConsulClient(rawClient);
        this.eventClient = new EventConsulClient(rawClient);
        this.healthClient = new HealthConsulClient(rawClient);
        this.keyValueClient = new KeyValueConsulClient(rawClient);
        this.sessionClient = new SessionConsulClient(rawClient);
        this.statusClient = new StatusConsulClient(rawClient);
    }

    public ConsulClient() {
        this(new ConsulRawClient());
    }

    public ConsulClient(TLSConfig tlsConfig) {
        this(new ConsulRawClient(tlsConfig));
    }

    public ConsulClient(String agentHost) {
        this(new ConsulRawClient(agentHost));
    }

    public ConsulClient(String agentHost, TLSConfig tlsConfig) {
        this(new ConsulRawClient(agentHost, tlsConfig));
    }

    public ConsulClient(String agentHost, int agentPort) {
        this(new ConsulRawClient(agentHost, agentPort));
    }

    public ConsulClient(String agentHost, int agentPort, TLSConfig tlsConfig) {
        this(new ConsulRawClient(agentHost, agentPort, tlsConfig));
    }

    @Override
    public Response<String> aclCreate(NewAcl newAcl, String token) {
        return this.aclClient.aclCreate(newAcl, token);
    }

    @Override
    public Response<Void> aclUpdate(UpdateAcl updateAcl, String token) {
        return this.aclClient.aclUpdate(updateAcl, token);
    }

    @Override
    public Response<Void> aclDestroy(String aclId, String token) {
        return this.aclClient.aclDestroy(aclId, token);
    }

    @Override
    public Response<Acl> getAcl(String id) {
        return this.aclClient.getAcl(id);
    }

    @Override
    public Response<String> aclClone(String aclId, String token) {
        return this.aclClient.aclClone(aclId, token);
    }

    @Override
    public Response<List<Acl>> getAclList(String token) {
        return this.aclClient.getAclList(token);
    }

    @Override
    public Response<Map<String, com.ecwid.consul.v1.agent.model.Check>> getAgentChecks() {
        return this.agentClient.getAgentChecks();
    }

    @Override
    public Response<Map<String, Service>> getAgentServices() {
        return this.agentClient.getAgentServices();
    }

    @Override
    public Response<List<Member>> getAgentMembers() {
        return this.agentClient.getAgentMembers();
    }

    @Override
    public Response<Self> getAgentSelf() {
        return this.agentClient.getAgentSelf();
    }

    @Override
    public Response<Void> agentJoin(String address, boolean wan) {
        return this.agentClient.agentJoin(address, wan);
    }

    @Override
    public Response<Void> agentForceLeave(String node) {
        return this.agentClient.agentForceLeave(node);
    }

    @Override
    public Response<Void> agentCheckRegister(NewCheck newCheck) {
        return this.agentClient.agentCheckRegister(newCheck);
    }

    @Override
    public Response<Void> agentCheckRegister(NewCheck newCheck, String token) {
        return this.agentClient.agentCheckRegister(newCheck, token);
    }

    @Override
    public Response<Void> agentCheckDeregister(String checkId) {
        return this.agentClient.agentCheckDeregister(checkId);
    }

    @Override
    public Response<Void> agentCheckPass(String checkId) {
        return this.agentClient.agentCheckPass(checkId);
    }

    @Override
    public Response<Void> agentCheckPass(String checkId, String note) {
        return this.agentClient.agentCheckPass(checkId, note);
    }

    @Override
    public Response<Void> agentCheckWarn(String checkId) {
        return this.agentClient.agentCheckWarn(checkId);
    }

    @Override
    public Response<Void> agentCheckWarn(String checkId, String note) {
        return this.agentClient.agentCheckWarn(checkId, note);
    }

    @Override
    public Response<Void> agentCheckFail(String checkId) {
        return this.agentClient.agentCheckFail(checkId);
    }

    @Override
    public Response<Void> agentCheckFail(String checkId, String note) {
        return this.agentClient.agentCheckFail(checkId, note);
    }

    @Override
    public Response<Void> agentServiceRegister(NewService newService) {
        return this.agentClient.agentServiceRegister(newService);
    }

    @Override
    public Response<Void> agentServiceRegister(NewService newService, String token) {
        return this.agentClient.agentServiceRegister(newService, token);
    }

    @Override
    public Response<Void> agentServiceDeregister(String serviceId) {
        return this.agentClient.agentServiceDeregister(serviceId);
    }

    @Override
    public Response<Void> catalogRegister(CatalogRegistration catalogRegistration) {
        return this.catalogClient.catalogRegister(catalogRegistration);
    }

    @Override
    public Response<Void> catalogDeregister(CatalogDeregistration catalogDeregistration) {
        return this.catalogClient.catalogDeregister(catalogDeregistration);
    }

    @Override
    public Response<List<String>> getCatalogDatacenters() {
        return this.catalogClient.getCatalogDatacenters();
    }

    @Override
    public Response<List<Node>> getCatalogNodes(QueryParams queryParams) {
        return this.catalogClient.getCatalogNodes(queryParams);
    }

    @Override
    public Response<Map<String, List<String>>> getCatalogServices(QueryParams queryParams) {
        return this.catalogClient.getCatalogServices(queryParams);
    }

    @Override
    public Response<List<CatalogService>> getCatalogService(String serviceName, QueryParams queryParams) {
        return this.catalogClient.getCatalogService(serviceName, queryParams);
    }

    @Override
    public Response<List<CatalogService>> getCatalogService(String serviceName, String tag, QueryParams queryParams) {
        return this.catalogClient.getCatalogService(serviceName, tag, queryParams);
    }

    @Override
    public Response<CatalogNode> getCatalogNode(String nodeName, QueryParams queryParams) {
        return this.catalogClient.getCatalogNode(nodeName, queryParams);
    }

    @Override
    public Response<Event> eventFire(String event, String payload, EventParams eventParams, QueryParams queryParams) {
        return this.eventClient.eventFire(event, payload, eventParams, queryParams);
    }

    @Override
    public Response<List<Event>> eventList(QueryParams queryParams) {
        return this.eventClient.eventList(queryParams);
    }

    @Override
    public Response<List<Event>> eventList(String event, QueryParams queryParams) {
        return this.eventClient.eventList(event, queryParams);
    }

    @Override
    public Response<List<Check>> getHealthChecksForNode(String nodeName, QueryParams queryParams) {
        return this.healthClient.getHealthChecksForNode(nodeName, queryParams);
    }

    @Override
    public Response<List<Check>> getHealthChecksForService(String serviceName, QueryParams queryParams) {
        return this.healthClient.getHealthChecksForService(serviceName, queryParams);
    }

    @Override
    public Response<List<HealthService>> getHealthServices(String serviceName, boolean onlyPassing, QueryParams queryParams) {
        return this.healthClient.getHealthServices(serviceName, onlyPassing, queryParams);
    }

    @Override
    public Response<List<HealthService>> getHealthServices(String serviceName, String tag, boolean onlyPassing, QueryParams queryParams) {
        return this.healthClient.getHealthServices(serviceName, tag, onlyPassing, queryParams);
    }

    @Override
    public Response<List<Check>> getHealthChecksState(QueryParams queryParams) {
        return this.healthClient.getHealthChecksState(queryParams);
    }

    @Override
    public Response<List<Check>> getHealthChecksState(Check.CheckStatus checkStatus, QueryParams queryParams) {
        return this.healthClient.getHealthChecksState(checkStatus, queryParams);
    }

    @Override
    public Response<GetValue> getKVValue(String key) {
        return this.keyValueClient.getKVValue(key);
    }

    @Override
    public Response<GetValue> getKVValue(String key, String token) {
        return this.keyValueClient.getKVValue(key, token);
    }

    @Override
    public Response<GetValue> getKVValue(String key, QueryParams queryParams) {
        return this.keyValueClient.getKVValue(key, queryParams);
    }

    @Override
    public Response<GetValue> getKVValue(String key, String token, QueryParams queryParams) {
        return this.keyValueClient.getKVValue(key, token, queryParams);
    }

    @Override
    public Response<GetBinaryValue> getKVBinaryValue(String key) {
        return this.keyValueClient.getKVBinaryValue(key);
    }

    @Override
    public Response<GetBinaryValue> getKVBinaryValue(String key, String token) {
        return this.keyValueClient.getKVBinaryValue(key, token);
    }

    @Override
    public Response<GetBinaryValue> getKVBinaryValue(String key, QueryParams queryParams) {
        return this.keyValueClient.getKVBinaryValue(key, queryParams);
    }

    @Override
    public Response<GetBinaryValue> getKVBinaryValue(String key, String token, QueryParams queryParams) {
        return this.keyValueClient.getKVBinaryValue(key, token, queryParams);
    }

    @Override
    public Response<List<GetValue>> getKVValues(String keyPrefix) {
        return this.keyValueClient.getKVValues(keyPrefix);
    }

    @Override
    public Response<List<GetValue>> getKVValues(String keyPrefix, String token) {
        return this.keyValueClient.getKVValues(keyPrefix, token);
    }

    @Override
    public Response<List<GetValue>> getKVValues(String keyPrefix, QueryParams queryParams) {
        return this.keyValueClient.getKVValues(keyPrefix, queryParams);
    }

    @Override
    public Response<List<GetValue>> getKVValues(String keyPrefix, String token, QueryParams queryParams) {
        return this.keyValueClient.getKVValues(keyPrefix, token, queryParams);
    }

    @Override
    public Response<List<GetBinaryValue>> getKVBinaryValues(String keyPrefix) {
        return this.keyValueClient.getKVBinaryValues(keyPrefix);
    }

    @Override
    public Response<List<GetBinaryValue>> getKVBinaryValues(String keyPrefix, String token) {
        return this.keyValueClient.getKVBinaryValues(keyPrefix, token);
    }

    @Override
    public Response<List<GetBinaryValue>> getKVBinaryValues(String keyPrefix, QueryParams queryParams) {
        return this.keyValueClient.getKVBinaryValues(keyPrefix, queryParams);
    }

    @Override
    public Response<List<GetBinaryValue>> getKVBinaryValues(String keyPrefix, String token, QueryParams queryParams) {
        return this.keyValueClient.getKVBinaryValues(keyPrefix, token, queryParams);
    }

    @Override
    public Response<List<String>> getKVKeysOnly(String keyPrefix) {
        return this.keyValueClient.getKVKeysOnly(keyPrefix);
    }

    @Override
    public Response<List<String>> getKVKeysOnly(String keyPrefix, String separator, String token) {
        return this.keyValueClient.getKVKeysOnly(keyPrefix, separator, token);
    }

    @Override
    public Response<List<String>> getKVKeysOnly(String keyPrefix, QueryParams queryParams) {
        return this.keyValueClient.getKVKeysOnly(keyPrefix, queryParams);
    }

    @Override
    public Response<List<String>> getKVKeysOnly(String keyPrefix, String separator, String token, QueryParams queryParams) {
        return this.keyValueClient.getKVKeysOnly(keyPrefix, separator, token, queryParams);
    }

    @Override
    public Response<Boolean> setKVValue(String key, String value) {
        return this.keyValueClient.setKVValue(key, value);
    }

    @Override
    public Response<Boolean> setKVValue(String key, String value, PutParams putParams) {
        return this.keyValueClient.setKVValue(key, value, putParams);
    }

    @Override
    public Response<Boolean> setKVValue(String key, String value, String token, PutParams putParams) {
        return this.keyValueClient.setKVValue(key, value, token, putParams);
    }

    @Override
    public Response<Boolean> setKVValue(String key, String value, QueryParams queryParams) {
        return this.keyValueClient.setKVValue(key, value, queryParams);
    }

    @Override
    public Response<Boolean> setKVValue(String key, String value, PutParams putParams, QueryParams queryParams) {
        return this.keyValueClient.setKVValue(key, value, putParams, queryParams);
    }

    @Override
    public Response<Boolean> setKVValue(String key, String value, String token, PutParams putParams, QueryParams queryParams) {
        return this.keyValueClient.setKVValue(key, value, token, putParams, queryParams);
    }

    @Override
    public Response<Boolean> setKVBinaryValue(String key, byte[] value) {
        return this.keyValueClient.setKVBinaryValue(key, value);
    }

    @Override
    public Response<Boolean> setKVBinaryValue(String key, byte[] value, PutParams putParams) {
        return this.keyValueClient.setKVBinaryValue(key, value, putParams);
    }

    @Override
    public Response<Boolean> setKVBinaryValue(String key, byte[] value, String token, PutParams putParams) {
        return this.keyValueClient.setKVBinaryValue(key, value, token, putParams);
    }

    @Override
    public Response<Boolean> setKVBinaryValue(String key, byte[] value, QueryParams queryParams) {
        return this.keyValueClient.setKVBinaryValue(key, value, queryParams);
    }

    @Override
    public Response<Boolean> setKVBinaryValue(String key, byte[] value, PutParams putParams, QueryParams queryParams) {
        return this.keyValueClient.setKVBinaryValue(key, value, putParams, queryParams);
    }

    @Override
    public Response<Boolean> setKVBinaryValue(String key, byte[] value, String token, PutParams putParams, QueryParams queryParams) {
        return this.keyValueClient.setKVBinaryValue(key, value, token, putParams, queryParams);
    }

    @Override
    public Response<Void> deleteKVValue(String key) {
        return this.keyValueClient.deleteKVValue(key);
    }

    @Override
    public Response<Void> deleteKVValue(String key, String token) {
        return this.keyValueClient.deleteKVValue(key, token);
    }

    @Override
    public Response<Void> deleteKVValue(String key, QueryParams queryParams) {
        return this.keyValueClient.deleteKVValue(key, queryParams);
    }

    @Override
    public Response<Void> deleteKVValue(String key, String token, QueryParams queryParams) {
        return this.keyValueClient.deleteKVValue(key, token, queryParams);
    }

    @Override
    public Response<Void> deleteKVValues(String key) {
        return this.keyValueClient.deleteKVValues(key);
    }

    @Override
    public Response<Void> deleteKVValues(String key, String token) {
        return this.keyValueClient.deleteKVValues(key, token);
    }

    @Override
    public Response<Void> deleteKVValues(String key, QueryParams queryParams) {
        return this.keyValueClient.deleteKVValues(key, queryParams);
    }

    @Override
    public Response<Void> deleteKVValues(String key, String token, QueryParams queryParams) {
        return this.keyValueClient.deleteKVValues(key, token, queryParams);
    }

    @Override
    public Response<String> sessionCreate(NewSession newSession, QueryParams queryParams) {
        return this.sessionClient.sessionCreate(newSession, queryParams);
    }

    @Override
    public Response<Void> sessionDestroy(String session, QueryParams queryParams) {
        return this.sessionClient.sessionDestroy(session, queryParams);
    }

    @Override
    public Response<Session> getSessionInfo(String session, QueryParams queryParams) {
        return this.sessionClient.getSessionInfo(session, queryParams);
    }

    @Override
    public Response<List<Session>> getSessionNode(String node, QueryParams queryParams) {
        return this.sessionClient.getSessionNode(node, queryParams);
    }

    @Override
    public Response<List<Session>> getSessionList(QueryParams queryParams) {
        return this.sessionClient.getSessionList(queryParams);
    }

    @Override
    public Response<Session> renewSession(String session, QueryParams queryParams) {
        return this.sessionClient.renewSession(session, queryParams);
    }

    @Override
    public Response<String> getStatusLeader() {
        return this.statusClient.getStatusLeader();
    }

    @Override
    public Response<List<String>> getStatusPeers() {
        return this.statusClient.getStatusPeers();
    }
}

