/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1;

import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.Utils;
import com.ecwid.consul.v1.ConsistencyMode;
import java.util.ArrayList;
import java.util.List;

public final class QueryParams
implements UrlParameters {
    public static final QueryParams DEFAULT = new QueryParams(ConsistencyMode.DEFAULT);
    private final String datacenter;
    private final ConsistencyMode consistencyMode;
    private final long waitTime;
    private final long index;

    public QueryParams(String datacenter) {
        this.datacenter = datacenter;
        this.consistencyMode = ConsistencyMode.DEFAULT;
        this.waitTime = -1L;
        this.index = -1L;
    }

    public QueryParams(ConsistencyMode consistencyMode) {
        this.datacenter = null;
        this.consistencyMode = consistencyMode;
        this.waitTime = -1L;
        this.index = -1L;
    }

    public QueryParams(String datacenter, ConsistencyMode consistencyMode) {
        this.datacenter = datacenter;
        this.consistencyMode = consistencyMode;
        this.waitTime = -1L;
        this.index = -1L;
    }

    public QueryParams(long waitTime, long index) {
        this.datacenter = null;
        this.consistencyMode = ConsistencyMode.DEFAULT;
        this.waitTime = waitTime;
        this.index = index;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public ConsistencyMode getConsistencyMode() {
        return this.consistencyMode;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public long getIndex() {
        return this.index;
    }

    @Override
    public List<String> toUrlParameters() {
        ArrayList<String> params = new ArrayList<String>();
        if (this.datacenter != null) {
            params.add("dc=" + Utils.encodeValue(this.datacenter));
        }
        if (this.consistencyMode != ConsistencyMode.DEFAULT) {
            params.add(this.consistencyMode.name().toLowerCase());
        }
        if (this.waitTime != -1L) {
            params.add("wait=" + this.waitTime + "s");
        }
        if (this.index != -1L) {
            params.add("index=" + this.index);
        }
        return params;
    }
}

