/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.server;

import com.eatthepath.pushy.apns.auth.ApnsVerificationKey;
import com.eatthepath.pushy.apns.auth.AuthenticationToken;
import com.eatthepath.pushy.apns.server.RejectedNotificationException;
import com.eatthepath.pushy.apns.server.RejectionReason;
import com.eatthepath.pushy.apns.server.ValidatingPushNotificationHandler;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenAuthenticationValidatingPushNotificationHandler
extends ValidatingPushNotificationHandler {
    private final Map<String, ApnsVerificationKey> verificationKeysByKeyId;
    private final Map<ApnsVerificationKey, Set<String>> topicsByVerificationKey;
    private String expectedTeamId;
    private static final AsciiString APNS_TOPIC_HEADER = new AsciiString((CharSequence)"apns-topic");
    private static final AsciiString APNS_AUTHORIZATION_HEADER = new AsciiString((CharSequence)"authorization");
    private static final Duration AUTHENTICATION_TOKEN_EXPIRATION_DURATION = Duration.ofHours(1L);
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticationValidatingPushNotificationHandler.class);

    TokenAuthenticationValidatingPushNotificationHandler(Map<String, Set<String>> deviceTokensByTopic, Map<String, Instant> expirationTimestampsByDeviceToken, Map<String, ApnsVerificationKey> verificationKeysByKeyId, Map<ApnsVerificationKey, Set<String>> topicsByVerificationKey) {
        super(deviceTokensByTopic, expirationTimestampsByDeviceToken);
        this.verificationKeysByKeyId = verificationKeysByKeyId;
        this.topicsByVerificationKey = topicsByVerificationKey;
    }

    @Override
    protected void verifyAuthentication(Http2Headers headers) throws RejectedNotificationException {
        AuthenticationToken authenticationToken;
        String authorizationString;
        CharSequence authorizationSequence = (CharSequence)headers.get((Object)APNS_AUTHORIZATION_HEADER);
        if (authorizationSequence != null) {
            authorizationString = authorizationSequence.toString();
            if (!authorizationString.startsWith("bearer")) {
                throw new RejectedNotificationException(RejectionReason.MISSING_PROVIDER_TOKEN);
            }
        } else {
            throw new RejectedNotificationException(RejectionReason.MISSING_PROVIDER_TOKEN);
        }
        String base64EncodedAuthenticationToken = authorizationString.substring("bearer".length()).trim();
        if (base64EncodedAuthenticationToken.trim().length() == 0) {
            throw new RejectedNotificationException(RejectionReason.MISSING_PROVIDER_TOKEN);
        }
        try {
            authenticationToken = new AuthenticationToken(base64EncodedAuthenticationToken);
        }
        catch (IllegalArgumentException e) {
            throw new RejectedNotificationException(RejectionReason.INVALID_PROVIDER_TOKEN);
        }
        ApnsVerificationKey verificationKey = this.verificationKeysByKeyId.get(authenticationToken.getKeyId());
        if (verificationKey == null) {
            throw new RejectedNotificationException(RejectionReason.INVALID_PROVIDER_TOKEN);
        }
        try {
            if (!authenticationToken.verifySignature(verificationKey)) {
                throw new RejectedNotificationException(RejectionReason.INVALID_PROVIDER_TOKEN);
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            log.error("Failed to verify authentication token signature.", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (this.expectedTeamId == null) {
            this.expectedTeamId = authenticationToken.getTeamId();
        }
        if (!this.expectedTeamId.equals(authenticationToken.getTeamId())) {
            throw new RejectedNotificationException(RejectionReason.INVALID_PROVIDER_TOKEN);
        }
        if (Instant.now().isAfter(authenticationToken.getIssuedAt().plus(AUTHENTICATION_TOKEN_EXPIRATION_DURATION))) {
            throw new RejectedNotificationException(RejectionReason.EXPIRED_PROVIDER_TOKEN);
        }
        CharSequence topicSequence = (CharSequence)headers.get((Object)APNS_TOPIC_HEADER);
        if (topicSequence == null) {
            throw new RejectedNotificationException(RejectionReason.MISSING_TOPIC);
        }
        String topic = topicSequence.toString();
        Set<String> topicsAllowedForVerificationKey = this.topicsByVerificationKey.get(verificationKey);
        if (topicsAllowedForVerificationKey == null || !topicsAllowedForVerificationKey.contains(topic)) {
            throw new RejectedNotificationException(RejectionReason.INVALID_PROVIDER_TOKEN);
        }
    }
}

