/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.ijk.widget.media;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.ActionBar;
import android.util.AttributeSet;
import android.view.View;
import android.widget.MediaController;
import com.easefun.polyvsdk.ijk.widget.media.IMediaController;
import java.util.ArrayList;

public class AndroidMediaController
extends MediaController
implements IMediaController {
    private ActionBar mActionBar;
    private ArrayList<View> mShowOnceArray = new ArrayList();

    public AndroidMediaController(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public AndroidMediaController(Context context, boolean useFastForward) {
        super(context, useFastForward);
        this.initView(context);
    }

    public AndroidMediaController(Context context) {
        super(context);
        this.initView(context);
    }

    private void initView(Context context) {
    }

    public void setSupportActionBar(@Nullable ActionBar actionBar) {
        this.mActionBar = actionBar;
        if (this.isShowing()) {
            actionBar.show();
        } else {
            actionBar.hide();
        }
    }

    @Override
    public void show() {
        super.show();
        if (this.mActionBar != null) {
            this.mActionBar.show();
        }
    }

    @Override
    public void hide() {
        super.hide();
        if (this.mActionBar != null) {
            this.mActionBar.hide();
        }
        for (View view : this.mShowOnceArray) {
            view.setVisibility(8);
        }
        this.mShowOnceArray.clear();
    }

    @Override
    public void showOnce(@NonNull View view) {
        this.mShowOnceArray.add(view);
        view.setVisibility(0);
        this.show();
    }
}

