/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.ijk.application;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

public class Settings {
    private Context mAppContext;
    private SharedPreferences mSharedPreferences;
    public static final int PV_PLAYER__Auto = 0;
    public static final int PV_PLAYER__AndroidMediaPlayer = 1;
    public static final int PV_PLAYER__IjkMediaPlayer = 2;
    public static final int PV_PLAYER__IjkExoMediaPlayer = 3;

    public Settings(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.mSharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.mAppContext);
    }

    public boolean getEnableBackgroundPlay() {
        return this.mSharedPreferences.getBoolean("polyv.pref.enable_background_play", false);
    }

    public int getPlayer() {
        String value = this.mSharedPreferences.getString("polyv.pref.player", "");
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public boolean getUsingMediaCodec() {
        return this.mSharedPreferences.getBoolean("polyv.pref.using_media_codec", false);
    }

    public boolean getUsingMediaCodecAutoRotate() {
        return this.mSharedPreferences.getBoolean("polyv.pref.using_media_codec_auto_rotate", false);
    }

    public boolean getUsingOpenSLES() {
        return this.mSharedPreferences.getBoolean("polyv.pref.using_opensl_es", false);
    }

    public String getPixelFormat() {
        return this.mSharedPreferences.getString("polyv.pref.pixel_format", "");
    }

    public boolean getEnableNoView() {
        return this.mSharedPreferences.getBoolean("polyv.pref.enable_no_view", false);
    }

    public boolean getEnableSurfaceView() {
        return this.mSharedPreferences.getBoolean("polyv.pref.enable_surface_view", false);
    }

    public boolean getEnableTextureView() {
        return this.mSharedPreferences.getBoolean("polyv.pref.enable_texture_view", false);
    }

    public boolean getEnableDetachedSurfaceTextureView() {
        return this.mSharedPreferences.getBoolean("polyv.pref.enable_detached_surface_texture", false);
    }

    public String getLastDirectory() {
        return this.mSharedPreferences.getString("polyv.pref.last_directory", "/");
    }

    public void setLastDirectory(String path) {
        this.mSharedPreferences.edit().putString("polyv.pref.last_directory", path).apply();
    }
}

