/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.sub.danmaku.entity;

import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import com.easefun.polyvsdk.sub.danmaku.auxiliary.PolyvDanmakuTransfer;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class PolyvDanmakuInfo
implements Serializable {
    public static final String FONTSIZE_LARGE = "24";
    public static final String FONTSIZE_MIDDLE = "18";
    public static final String FONTSIZE_SMALL = "16";
    public static final String FONTMODE_ROLL = "roll";
    public static final String FONTMODE_TOP = "top";
    public static final String FONTMODE_BOTTOM = "bottom";
    private String msg;
    private String time;
    private String fontSize;
    private String fontMode;
    private String fontColor;
    private String timestamp;
    public String vid;

    public PolyvDanmakuInfo(@NonNull String vid, @NonNull String msg, @NonNull String time) {
        this(vid, msg, time, FONTSIZE_MIDDLE, FONTMODE_ROLL, -1);
    }

    public PolyvDanmakuInfo(@NonNull String vid, @NonNull String msg, @NonNull String time, String fontSize, String fontMode, @ColorInt int fontColor) {
        this.vid = PolyvDanmakuTransfer.checkVid(vid);
        this.msg = PolyvDanmakuTransfer.checkMsg(msg);
        this.time = PolyvDanmakuTransfer.checkTime(time);
        this.fontSize = PolyvDanmakuTransfer.checkFontSizeTransfer(fontSize);
        this.fontMode = PolyvDanmakuTransfer.checkFontModeTransfer(fontMode);
        this.fontColor = PolyvDanmakuTransfer.checkFontColorTransfer(fontColor);
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontMode() {
        return this.fontMode;
    }

    public void setFontMode(String fontMode) {
        this.fontMode = fontMode;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        return "PolyvDanmakuInfo{msg='" + this.msg + '\'' + ", time='" + this.time + '\'' + ", fontSize='" + this.fontSize + '\'' + ", fontMode='" + this.fontMode + '\'' + ", fontColor='" + this.fontColor + '\'' + ", timestamp='" + this.timestamp + '\'' + '}';
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FontMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FontSize {
    }
}

