/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.sub.danmaku.auxiliary;

import java.util.Locale;

public class PolyvDanmakuTransfer {
    public static String checkVid(String vid) {
        if (vid == null) {
            throw new NullPointerException("vid is null");
        }
        return vid;
    }

    public static String checkTime(String time) {
        if (time == null) {
            throw new NullPointerException("time is null");
        }
        if (!time.matches("[0-9][0-9]:[0-5][0-9]:[0-5][0-9]")) {
            throw new IllegalArgumentException("time format is not correct.and see [0-9][0-9]:[0-5][0-9]:[0-5][0-9]");
        }
        return time;
    }

    public static String checkMsg(String msg) {
        if (msg == null) {
            throw new NullPointerException("msg is null");
        }
        if (msg.trim().length() == 0) {
            throw new IllegalArgumentException("msg cannot be empty");
        }
        return msg;
    }

    public static String checkFontSizeTransfer(String fontSize) {
        if (fontSize == null) {
            throw new NullPointerException("fontSize is null");
        }
        if (!(fontSize.equals("24") || fontSize.equals("18") || fontSize.equals("16"))) {
            return "18";
        }
        return fontSize;
    }

    public static String checkFontModeTransfer(String fontMode) {
        if (fontMode == null) {
            throw new NullPointerException("fontMode is null");
        }
        if (!(fontMode.equals("roll") || fontMode.equals("top") || fontMode.equals("bottom"))) {
            return "roll";
        }
        return fontMode;
    }

    public static String checkFontColorTransfer(int fontColor) {
        if ((fontColor | 0xFF000000) > -1 || (fontColor | 0xFF000000) < -16777216) {
            return PolyvDanmakuTransfer.toPolyvFontColor(-1);
        }
        return PolyvDanmakuTransfer.toPolyvFontColor(fontColor);
    }

    private static String toPolyvFontColor(int fontColor) {
        String hex = Integer.toHexString(fontColor);
        if (hex.length() != "FFFFFFFF".length()) {
            return "0xFFFFFF";
        }
        return "0x" + hex.substring(2).toUpperCase();
    }

    public static String toPolyvDanmakuTime(long milliseconds) {
        int totalSeconds = (int)(milliseconds / 1000L);
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        return String.format(Locale.getDefault(), "%02d:%02d:%02d", hours, minutes, seconds);
    }
}

