/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.sub.danmaku.auxiliary;

import com.easefun.polyvsdk.sub.danmaku.auxiliary.DanmakuXmlSerializer;
import com.easefun.polyvsdk.sub.danmaku.entity.PolyvDanmakuInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class BilibiliDanmakuTransfer {
    public static long toBilibiliTime(String time) {
        if (!time.matches("[0-9][0-9]:[0-5][0-9]:[0-5][0-9]")) {
            time = "00:00:00";
        }
        String[] str = time.split(":");
        int hour = Integer.parseInt(str[0]);
        int minute = Integer.parseInt(str[1]);
        int seconds = Integer.parseInt(str[2]);
        return hour * 3600 + minute * 60 + seconds;
    }

    public static int toBilibiliFontMode(String fontMode) {
        if (fontMode.equals("top")) {
            return 5;
        }
        if (fontMode.equals("bottom")) {
            return 4;
        }
        return 1;
    }

    public static long toBilibiliColor(String color) {
        return Integer.parseInt(color.substring(2), 16);
    }

    public static InputStream transferToInputStream(List<PolyvDanmakuInfo> ls_danmakuInfos) throws IOException {
        if (ls_danmakuInfos == null || ls_danmakuInfos.size() < 1) {
            return null;
        }
        DanmakuXmlSerializer xmlSerializer = new DanmakuXmlSerializer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StringBuilder stringBuilder = new StringBuilder();
        xmlSerializer.setOutput(baos, "utf-8");
        xmlSerializer.startDocument("utf-8", true);
        xmlSerializer.startTag(null, "i").startTag(null, "chatserver").text("www.polyv.net").endTag(null, "chatserver").startTag(null, "chatid").text("123456").endTag(null, "chatid").startTag(null, "mission").text("0").endTag(null, "mission").startTag(null, "maxlimit").text("123456").endTag(null, "maxlimit").startTag(null, "source").text("k-v").endTag(null, "source");
        for (PolyvDanmakuInfo danmakuInfo : ls_danmakuInfos) {
            String danmakuPoolId;
            String userHash;
            long time = BilibiliDanmakuTransfer.toBilibiliTime(danmakuInfo.getTime());
            int fontMode = BilibiliDanmakuTransfer.toBilibiliFontMode(danmakuInfo.getFontMode());
            String fontSize = danmakuInfo.getFontSize();
            long fontColor = BilibiliDanmakuTransfer.toBilibiliColor(danmakuInfo.getFontColor());
            String timestamp = danmakuInfo.getTimestamp();
            String danmakuId = userHash = (danmakuPoolId = "123456");
            String divider = ",";
            String danmakuMsg = danmakuInfo.getMsg();
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append(time).append(divider).append(fontMode).append(divider).append(fontSize).append(divider).append(fontColor).append(divider).append(timestamp).append(divider).append(danmakuPoolId).append(divider).append(userHash).append(divider).append(danmakuId);
            xmlSerializer.startTag(null, "d");
            xmlSerializer.attribute(null, "p", stringBuilder.toString());
            xmlSerializer.text(danmakuMsg);
            xmlSerializer.endTag(null, "d");
        }
        xmlSerializer.endTag(null, "i");
        xmlSerializer.endDocument();
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

