/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.sub.auxilliary;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.storage.StorageManager;
import java.io.File;
import java.lang.reflect.Method;

public class SDCardUtil {
    public static File getDiskCacheDir(Context context, String path) {
        return new File(SDCardUtil.getDiskCacheDir(context), path);
    }

    public static File getDiskCacheDir(Context context) {
        return "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getExternalCacheDir() : context.getCacheDir();
    }

    public static String createPath(Context context, String path) {
        String[] allPaths = SDCardUtil.getVolumePaths(context);
        String fitPath = null;
        String internalPath = null;
        long maxTotal = 0L;
        for (String parentPath : allPaths) {
            boolean isMounted = SDCardUtil.checkMounted(context, parentPath);
            if (!isMounted) continue;
            long total = SDCardUtil.getSDTotalSize(context, parentPath);
            if (total > maxTotal) {
                maxTotal = total;
                fitPath = parentPath;
            }
            if (SDCardUtil.isRemovableSD(context, parentPath)) continue;
            internalPath = parentPath;
        }
        File creataFile = new File(fitPath, path);
        if (SDCardUtil.isRemovableSD(context, fitPath)) {
            context.getExternalFilesDir(null);
            if (!creataFile.exists()) {
                creataFile.mkdirs();
            }
            if (!creataFile.exists()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(fitPath).append(File.separator).append("Android").append(File.separator).append("data").append(File.separator).append(context.getPackageName()).append(File.separator).append(path);
                creataFile = new File(stringBuilder.toString());
                if (!creataFile.exists()) {
                    creataFile.mkdirs();
                }
                if (!creataFile.exists() && internalPath != null && !(creataFile = new File(internalPath, path)).exists()) {
                    creataFile.mkdirs();
                }
            }
        } else if (!creataFile.exists()) {
            creataFile.mkdirs();
        }
        return creataFile.exists() ? creataFile.getAbsolutePath() : null;
    }

    public static boolean isRemovableSD(Context context, String sdPath) {
        String eExternal = Environment.getExternalStorageDirectory().getAbsolutePath();
        if (SDCardUtil.isInternalSD(context, eExternal)) {
            return !sdPath.startsWith(eExternal);
        }
        return !sdPath.startsWith(SDCardUtil.getInternalSDPath(context));
    }

    public static String getExtenalSDPath(Context context) {
        String[] allPaths = SDCardUtil.getVolumePaths(context);
        if (allPaths != null && allPaths.length > 0) {
            for (int i = 0; i < allPaths.length; ++i) {
                if (!SDCardUtil.isRemovableSD(context, allPaths[i]) || !SDCardUtil.checkMounted(context, allPaths[i])) continue;
                return allPaths[i];
            }
        }
        return " ";
    }

    public static boolean externalSDIsMounted(Context context) {
        return !SDCardUtil.getExtenalSDPath(context).equals(" ");
    }

    public static boolean internalSDIsMounted(Context context) {
        return !SDCardUtil.getInternalSDPath(context).equals(" ");
    }

    public static String getInternalSDPath(Context context) {
        String[] allPaths = SDCardUtil.getVolumePaths(context);
        if (allPaths != null && allPaths.length > 0) {
            for (int i = 0; i < allPaths.length; ++i) {
                if (!SDCardUtil.isInternalSD(context, allPaths[i]) || !SDCardUtil.checkMounted(context, allPaths[i])) continue;
                return allPaths[i];
            }
        }
        return " ";
    }

    private static boolean isInternalSD(Context context, String sdPath) {
        if (context == null) {
            return true;
        }
        Class<?> mStorageVolume = null;
        StorageManager mStorageManager = null;
        Method mGetVolumeListMethod = null;
        Method mIsRemovableMethod = null;
        Object[] mStorageVolumeList = null;
        try {
            mStorageManager = (StorageManager)context.getSystemService("storage");
            mStorageVolume = Class.forName("android.os.storage.StorageVolume");
            mGetVolumeListMethod = mStorageManager.getClass().getMethod("getVolumeList", new Class[0]);
            mIsRemovableMethod = mStorageVolume.getMethod("isRemovable", new Class[0]);
            mStorageVolumeList = (Object[])mGetVolumeListMethod.invoke((Object)mStorageManager, new Object[0]);
            if (mStorageVolumeList != null && mStorageVolumeList.length > 0) {
                for (int i = 0; i < mStorageVolumeList.length; ++i) {
                    String mStoragePath = (String)mStorageVolume.getMethod("getPath", new Class[0]).invoke(mStorageVolumeList[i], new Object[0]);
                    boolean isRemovableSD = (Boolean)mIsRemovableMethod.invoke(mStorageVolumeList[i], new Object[0]);
                    if (!sdPath.startsWith(mStoragePath) || !isRemovableSD) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static String[] getVolumePaths(Context context) {
        String[] paths = null;
        StorageManager mStorageManager = null;
        Method mMethodGetPaths = null;
        try {
            mStorageManager = (StorageManager)context.getSystemService("storage");
            mMethodGetPaths = mStorageManager.getClass().getMethod("getVolumePaths", new Class[0]);
            paths = (String[])mMethodGetPaths.invoke((Object)mStorageManager, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return paths;
    }

    public static boolean checkMounted(Context context, String mountPoint) {
        if (mountPoint == null) {
            return false;
        }
        StorageManager storageManager = (StorageManager)context.getSystemService("storage");
        try {
            Method getVolumeState = storageManager.getClass().getMethod("getVolumeState", String.class);
            String state = (String)getVolumeState.invoke((Object)storageManager, mountPoint);
            return "mounted".equals(state);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long getSDTotalSize(Context context, String path) {
        if (new File(path).exists()) {
            StatFs stat = new StatFs(path);
            long blockSize = 0L;
            long totalBlocks = 0L;
            if (Build.VERSION.SDK_INT >= 18) {
                if (stat != null) {
                    blockSize = stat.getBlockSizeLong();
                    totalBlocks = stat.getBlockCountLong();
                }
            } else if (stat != null) {
                blockSize = stat.getBlockSize();
                totalBlocks = stat.getBlockCount();
            }
            return blockSize * totalBlocks;
        }
        return 0L;
    }

    public static long getSDAvailableSize(Context context, String path) {
        if (new File(path).exists()) {
            StatFs stat = new StatFs(path);
            long blockSize = 0L;
            long availableBlocks = 0L;
            if (Build.VERSION.SDK_INT >= 18) {
                if (stat != null) {
                    blockSize = stat.getBlockSizeLong();
                    availableBlocks = stat.getAvailableBlocksLong();
                }
            } else if (stat != null) {
                blockSize = stat.getBlockSize();
                availableBlocks = stat.getAvailableBlocks();
            }
            return blockSize * availableBlocks;
        }
        return 0L;
    }

    public static long getRomTotalSize(Context context) {
        long totalBlocks;
        long blockSize;
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = stat.getBlockSizeLong();
            totalBlocks = stat.getBlockCountLong();
        } else {
            blockSize = stat.getBlockSize();
            totalBlocks = stat.getBlockCount();
        }
        return blockSize * totalBlocks;
    }

    public static long getRomAvailableSize(Context context) {
        long availableBlocks;
        long blockSize;
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = stat.getBlockSizeLong();
            availableBlocks = stat.getAvailableBlocksLong();
        } else {
            blockSize = stat.getBlockSize();
            availableBlocks = stat.getAvailableBlocks();
        }
        return blockSize * availableBlocks;
    }
}

