/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.sub.auxilliary;

import android.util.Log;
import com.easefun.polyvsdk.sub.auxilliary.CheckRuntime;
import com.easefun.polyvsdk.sub.auxilliary.IOUtil;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LogUtil {
    public static boolean isShow = true;
    public static String TAG = "polyv";
    public static final int LEVEL_DEFAULT = -1;
    public static int level = -1;
    public static final int V = 0;
    public static final int D = 1;
    public static final int I = 2;
    public static final int W = 3;
    public static final int E = 4;

    private LogUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static void init(boolean isShow, String tag, int level) {
        CheckRuntime.checkNotNull("tag", tag);
        LogUtil.isShow = isShow;
        TAG = tag;
        if (level < -1 || level > 4) {
            level = -1;
        }
        LogUtil.level = level;
    }

    private static void checkShow(String tag, String msg, Throwable t) {
        switch (level) {
            case 0: {
                LogUtil.v_show(tag, msg, t);
                break;
            }
            case 1: {
                LogUtil.d_show(tag, msg, t);
                break;
            }
            case 2: {
                LogUtil.i_show(tag, msg, t);
                break;
            }
            case 3: {
                LogUtil.w_show(tag, msg, t);
                break;
            }
            case 4: {
                LogUtil.e_show(tag, msg, t);
            }
        }
    }

    public static void i(String msg) {
        LogUtil.i(TAG, msg);
    }

    public static void i(String msg, Throwable t) {
        LogUtil.i(TAG, msg, t);
    }

    public static void i(String tag, String msg) {
        LogUtil.i(tag, msg, null);
    }

    public static void i(String tag, String msg, Throwable t) {
        if (level == -1) {
            LogUtil.i_show(tag, msg, t);
        } else {
            LogUtil.checkShow(tag, msg, t);
        }
    }

    private static void i_show(String tag, String msg, Throwable t) {
        if (isShow) {
            Log.i((String)tag, (String)(msg + "\n" + LogUtil.getStackTraceString(t)));
        }
    }

    public static void d(String msg) {
        LogUtil.d(TAG, msg);
    }

    public static void d(String msg, Throwable t) {
        LogUtil.d(TAG, msg, t);
    }

    public static void d(String tag, String msg) {
        LogUtil.d(tag, msg, null);
    }

    public static void d(String tag, String msg, Throwable t) {
        if (level == -1) {
            LogUtil.d_show(tag, msg, t);
        } else {
            LogUtil.checkShow(tag, msg, t);
        }
    }

    private static void d_show(String tag, String msg, Throwable t) {
        if (isShow) {
            Log.d((String)tag, (String)(msg + "\n" + LogUtil.getStackTraceString(t)));
        }
    }

    public static void v(String msg) {
        LogUtil.v(TAG, msg);
    }

    public static void v(String msg, Throwable t) {
        LogUtil.v(TAG, msg, t);
    }

    public static void v(String tag, String msg) {
        LogUtil.v(tag, msg, null);
    }

    public static void v(String tag, String msg, Throwable t) {
        if (level == -1) {
            LogUtil.v_show(tag, msg, t);
        } else {
            LogUtil.checkShow(tag, msg, t);
        }
    }

    private static void v_show(String tag, String msg, Throwable t) {
        if (isShow) {
            Log.v((String)tag, (String)(msg + "\n" + LogUtil.getStackTraceString(t)));
        }
    }

    public static void e(String msg) {
        LogUtil.e(TAG, msg);
    }

    public static void e(String msg, Throwable t) {
        LogUtil.e(TAG, msg, t);
    }

    public static void e(String tag, String msg) {
        LogUtil.e(tag, msg, null);
    }

    public static void e(String tag, String msg, Throwable t) {
        if (level == -1) {
            LogUtil.e_show(tag, msg, t);
        } else {
            LogUtil.checkShow(tag, msg, t);
        }
    }

    private static void e_show(String tag, String msg, Throwable t) {
        if (isShow) {
            Log.e((String)tag, (String)(msg + "\n" + LogUtil.getStackTraceString(t)));
        }
    }

    public static void w(String msg) {
        LogUtil.w(TAG, msg);
    }

    public static void w(String msg, Throwable t) {
        LogUtil.w(TAG, msg, t);
    }

    public static void w(String tag, String msg) {
        LogUtil.w(tag, msg, null);
    }

    public static void w(String tag, String msg, Throwable t) {
        if (level == -1) {
            LogUtil.w_show(tag, msg, t);
        } else {
            LogUtil.checkShow(tag, msg, t);
        }
    }

    private static void w_show(String tag, String msg, Throwable t) {
        if (isShow) {
            Log.w((String)tag, (String)(msg + "\n" + LogUtil.getStackTraceString(t)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTraceString(Throwable throwable) {
        String string;
        if (throwable == null) {
            return "";
        }
        StringWriter errors = null;
        PrintWriter printWriter = null;
        try {
            String message;
            errors = new StringWriter();
            printWriter = new PrintWriter(errors);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            string = message = errors.toString();
        }
        catch (Throwable throwable2) {
            IOUtil.closeIO(printWriter);
            throw throwable2;
        }
        IOUtil.closeIO(printWriter);
        return string;
    }
}

