package com.easefun.polyvsdk.sub.vlms.auxiliary;

/**
 * 用于转换一些有关发送到网校接口的数据
 */
public class PolyvVlmsTransfer {

    /**
     * 转换从网校获取到的数据的html标签(获取/添加成功的问题/回复的文本需要转换，获取的概述的文本需要转换)
     * @param htmlText html文本
     * @param toHtmlText 该文本是否要让Html.fromHtml解析
     * @return
     */
    //toHtmlText:该文本是否要让Html.fromHtml解析
    public static String fromHtmlText(String htmlText, boolean toHtmlText) {
        String reg1 = "</p>";
        String reg2 = "(<[^b^/^a][^r^>][^>][^>]*>)|(</[^a][^>]*>)|(<b>)|(<p>[\\s]*)|(\\n)";
        String reg3 = "(<[^i^/][^m^r^>][^g^>][^>]*>)|(</[^p][^>]*>)|(<b>)|(<p>[\\s]*)|(\\n)";
        String reg4 = "(</p>)|(<br[\\s]?/>)";
        if (toHtmlText)
            htmlText = htmlText.replaceAll(reg1, "<br>").replaceAll(reg2, "");
        else {
            htmlText = fromHtmlSign(htmlText, false);
            htmlText = htmlText.replaceAll(reg3, "").replaceAll(reg4, "\r\n");
            htmlText = fromHtmlSign(htmlText, true);
        }
        htmlText = ("a" + htmlText).trim().substring(1);
        if (htmlText.endsWith("<br>") || htmlText.endsWith("\r\n"))
            htmlText = htmlText.substring(0, htmlText.length() - 4);
        return htmlText;
    }

    //转换html符号为通常符号
    private static String fromHtmlSign(String htmlText, boolean onlyChangeSpace) {
        if (onlyChangeSpace)
            htmlText = htmlText.replaceAll("&nbsp;", " ");// 替换空格
        else {
            htmlText = htmlText.replaceAll("&apos;", "'");
            htmlText = htmlText.replaceAll("&quot;", "\"");
            htmlText = htmlText.replaceAll("&nbsp;&nbsp;", "\t");// 替换跳格
            htmlText = htmlText.replaceAll("&lt;", "<");
            htmlText = htmlText.replaceAll("&gt;", ">");
        }
        return htmlText;
    }

    /**
     * 转换到html符号(添加问题/回复的文本需要转换)
     * @param msg 需要发送的信息
     * @return 转换后的信息
     */
    public static String toHtmlSign(String msg) {
        msg = msg.replaceAll(" ", "&nbsp;");
        msg = msg.replaceAll("\\t", "&nbsp;&nbsp;");
        msg = msg.replaceAll("\"", "&quot;");
        msg = msg.replaceAll("<", "&lt;");
        msg = msg.replaceAll(">", "&gt;");
        msg = msg.replaceAll("\\n", "<br/>");
        return msg;
    }
}
