package com.easefun.polyvsdk.sub.danmaku.auxiliary;


import com.easefun.polyvsdk.sub.danmaku.entity.PolyvDanmakuInfo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import master.flame.danmaku.danmaku.model.BaseDanmaku;

public class BilibiliDanmakuTransfer {

    public static long toBilibiliTime(String time){
        if (!time.matches("[0-9][0-9]:[0-5][0-9]:[0-5][0-9]"))
            time = "00:00:00";
        String str[] = time.split(":");
        int hour = Integer.parseInt(str[0]);
        int minute = Integer.parseInt(str[1]);
        int seconds = Integer.parseInt(str[2]);
        return hour * 3600 + minute * 60 + seconds;
    }

    public static int toBilibiliFontMode(String fontMode){
        if (fontMode.equals("top"))
            return BaseDanmaku.TYPE_FIX_TOP;
        else if (fontMode.equals("bottom"))
            return BaseDanmaku.TYPE_FIX_BOTTOM;
        else
            return BaseDanmaku.TYPE_SCROLL_RL;
    }

    public static long toBilibiliColor(String color){
        return Integer.parseInt(color.substring(2), 16);
    }

    public static InputStream transferToInputStream(List<PolyvDanmakuInfo> ls_danmakuInfos) throws IOException {
        if (ls_danmakuInfos == null || ls_danmakuInfos.size() < 1)
            return null;
        DanmakuXmlSerializer xmlSerializer = new DanmakuXmlSerializer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StringBuilder stringBuilder = new StringBuilder();
        xmlSerializer.setOutput(baos, "utf-8");
        xmlSerializer.startDocument("utf-8", true);
        xmlSerializer.startTag(null, "i").startTag(null, "chatserver").text("www.polyv.net")
                .endTag(null, "chatserver").startTag(null, "chatid").text("123456").endTag(null, "chatid")
                .startTag(null, "mission").text("0").endTag(null, "mission").startTag(null, "maxlimit")
                .text("123456").endTag(null, "maxlimit").startTag(null, "source").text("k-v")
                .endTag(null, "source");
       for(PolyvDanmakuInfo danmakuInfo : ls_danmakuInfos){
           //时间
           long time = toBilibiliTime(danmakuInfo.getTime());
           //类型
           int fontMode = toBilibiliFontMode(danmakuInfo.getFontMode());
           //字号
           String fontSize = danmakuInfo.getFontSize();
           //颜色
           long fontColor = toBilibiliColor(danmakuInfo.getFontColor());
           //时间戳
           String timestamp = danmakuInfo.getTimestamp();
           //弹幕池id
           String danmakuPoolId = "123456";
           //用户hash
           String userHash = danmakuPoolId;
           //弹幕id
           String danmakuId = userHash;
           //分割
           String divider = ",";
           //弹幕信息
           String danmakuMsg = danmakuInfo.getMsg();
           stringBuilder.delete(0,stringBuilder.length());
           stringBuilder.append(time).append(divider).append(fontMode).append(divider).append(fontSize).append(divider)
                   .append(fontColor).append(divider).append(timestamp).append(divider).append(danmakuPoolId).append(divider)
                   .append(userHash).append(divider).append(danmakuId);
           xmlSerializer.startTag(null, "d");
           xmlSerializer.attribute(null, "p", stringBuilder.toString());
           xmlSerializer.text(danmakuMsg);
           xmlSerializer.endTag(null, "d");
       }
        xmlSerializer.endTag(null, "i");
        xmlSerializer.endDocument();
        return new ByteArrayInputStream(baos.toByteArray());
    }
}
