package com.easefun.polyvsdk.sub.auxilliary;

import java.util.Map;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface PolyvVlmsApi {

    @GET("oauth2/authorize")
    Call<ResponseBody> getAccessToken(@QueryMap Map<String, Object> map);

    @GET("oauth2/refresh_token")
    Call<ResponseBody> refreshAccessToken(@QueryMap Map<String, Object> map);

    @GET("api/courses")
    Call<ResponseBody> getCourses(@QueryMap Map<String, Object> map);

    @GET("api/course/{courseId}")
    Call<ResponseBody> getCourseDetail(@Path("courseId") String courseId, @QueryMap Map<String, Object> map);

    @POST("api/login")
    Call<ResponseBody> login(@Body Map<String, Object> map);//@Body非表单提交(可以适用于提交json数据,否则返回html数据)

    @GET("api/curriculum")
    Call<ResponseBody> getCurriculum(@QueryMap Map<String, Object> map);

    @POST("api/myorder")
    Call<ResponseBody> addOrder(@Body Map<String, Object> map);

    @GET("api/question")
    Call<ResponseBody> getQuestion(@QueryMap Map<String, Object> map);

    @GET("api/answer")
    Call<ResponseBody> getAnswer(@QueryMap Map<String, Object> map);

    @POST("api/question")
    Call<ResponseBody> addNewQuestion(@Body Map<String, Object> map);

    @POST("api/answer")
    Call<ResponseBody> addNewAnswer(@Body Map<String, Object> map);
}

