package com.easefun.polyvsdk.sub.auxilliary;

import android.util.Log;

import java.io.PrintWriter;
import java.io.StringWriter;

public class LogUtil {

    private LogUtil() {
        /* cannot be instantiated */
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static boolean isShow = true;
    public static String TAG = "polyv";
    public static final int LEVEL_DEFAULT = -1;
    public static int level = LEVEL_DEFAULT;
    public static final int V = 0;
    public static final int D = 1;
    public static final int I = 2;
    public static final int W = 3;
    public static final int E = 4;

    public static void init(boolean isShow, String tag, int level) {
        CheckRuntime.checkNotNull("tag", tag);
        LogUtil.isShow = isShow;
        LogUtil.TAG = tag;
        if (level < LEVEL_DEFAULT || level > E)
            level = LEVEL_DEFAULT;
        LogUtil.level = level;
    }

    private static void checkShow(String tag, String msg, Throwable t) {
        switch (level) {
            case V:
                v_show(tag, msg, t);
                break;
            case D:
                d_show(tag, msg, t);
                break;
            case I:
                i_show(tag, msg, t);
                break;
            case W:
                w_show(tag, msg, t);
                break;
            case E:
                e_show(tag, msg, t);
                break;
        }
    }

    public static void i(String msg) {
        i(TAG, msg);
    }

    public static void i(String msg, Throwable t) {
        i(TAG, msg, t);
    }

    public static void i(String tag, String msg) {
        i(tag, msg, null);
    }

    public static void i(String tag, String msg, Throwable t) {
        if (level == LEVEL_DEFAULT)
            i_show(tag, msg, t);
        else
            checkShow(tag, msg, t);
    }

    private static void i_show(String tag, String msg, Throwable t) {
        if (isShow)
            Log.i(tag, msg + "\n" + getStackTraceString(t));
    }

    public static void d(String msg) {
        d(TAG, msg);
    }

    public static void d(String msg, Throwable t) {
        d(TAG, msg, t);
    }

    public static void d(String tag, String msg) {
        d(tag, msg, null);
    }

    public static void d(String tag, String msg, Throwable t) {
        if (level == LEVEL_DEFAULT)
            d_show(tag, msg, t);
        else
            checkShow(tag, msg, t);
    }

    private static void d_show(String tag, String msg, Throwable t) {
        if (isShow)
            Log.d(tag, msg + "\n" + getStackTraceString(t));
    }

    public static void v(String msg) {
        v(TAG, msg);
    }

    public static void v(String msg, Throwable t) {
        v(TAG, msg, t);
    }

    public static void v(String tag, String msg) {
        v(tag, msg, null);
    }

    public static void v(String tag, String msg, Throwable t) {
        if (level == LEVEL_DEFAULT)
            v_show(tag, msg, t);
        else
            checkShow(tag, msg, t);
    }

    private static void v_show(String tag, String msg, Throwable t) {
        if (isShow)
            Log.v(tag, msg + "\n" + getStackTraceString(t));
    }

    public static void e(String msg) {
        e(TAG, msg);
    }

    public static void e(String msg, Throwable t) {
        e(TAG, msg, t);
    }

    public static void e(String tag, String msg) {
        e(tag, msg, null);
    }

    public static void e(String tag, String msg, Throwable t) {
        if (level == LEVEL_DEFAULT)
            e_show(tag, msg, t);
        else
            checkShow(tag, msg, t);
    }

    private static void e_show(String tag, String msg, Throwable t) {
        if (isShow)
            Log.e(tag, msg + "\n" + getStackTraceString(t));
    }

    public static void w(String msg) {
        w(TAG, msg);
    }

    public static void w(String msg, Throwable t) {
        w(TAG, msg, t);
    }

    public static void w(String tag, String msg) {
        w(tag, msg, null);
    }

    public static void w(String tag, String msg, Throwable t) {
        if (level == LEVEL_DEFAULT)
            w_show(tag, msg, t);
        else
            checkShow(tag, msg, t);
    }

    private static void w_show(String tag, String msg, Throwable t) {
        if (isShow)
            Log.w(tag, msg + "\n" + getStackTraceString(t));
    }

    // 获取异常的追踪输出
    public static String getStackTraceString(Throwable throwable) {
        if (throwable == null)
            return "";
        StringWriter errors = null;
        PrintWriter printWriter = null;
        try {
            errors = new StringWriter();
            printWriter = new PrintWriter(errors);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            String message = errors.toString();
            // 取消可以定位
            // message=message.replaceAll("\n", "");
            return message;
        } finally {
            IOUtil.closeIO(printWriter);
        }
    }
}
