package com.easefun.polyvsdk.sub.auxilliary;

import android.text.TextUtils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IOUtil {

    public static boolean saveObjectToFile(String filePath, Object object) {
        if (!TextUtils.isEmpty(filePath)) {
            File cacheFile = null;

            try {
                cacheFile = new File(filePath);
                if (cacheFile.exists()) {
                    cacheFile.delete();
                }

                if (!cacheFile.getParentFile().exists()) {
                    cacheFile.getParentFile().mkdirs();
                }

                cacheFile.createNewFile();
            } catch (Throwable var6) {
                LogUtil.w("saveObjectToFile", var6);
                cacheFile = null;
            }

            if (cacheFile != null) {
                ObjectOutputStream oos = null;
                try {
                    FileOutputStream t = new FileOutputStream(cacheFile);
                    GZIPOutputStream gzos = new GZIPOutputStream(t);
                    oos = new ObjectOutputStream(gzos);
                    oos.writeObject(object);
                    oos.flush();
                    return true;
                } catch (Throwable var7) {
                    LogUtil.w("saveObjectToFile", var7);
                } finally {
                    IOUtil.closeIO(oos);
                }
            }
        }

        return false;
    }

    public static Object readObjectFromFile(String filePath) {
        if (!TextUtils.isEmpty(filePath)) {
            File cacheFile = null;

            try {
                cacheFile = new File(filePath);
                if (!cacheFile.exists()) {
                    cacheFile = null;
                }
            } catch (Throwable var6) {
                LogUtil.w("readObjectFromFile", var6);
                cacheFile = null;
            }

            if (cacheFile != null) {
                ObjectInputStream ois = null;
                try {
                    FileInputStream t = new FileInputStream(cacheFile);
                    GZIPInputStream gzis = new GZIPInputStream(t);
                    ois = new ObjectInputStream(gzis);
                    Object object = ois.readObject();

                    return object;
                } catch (Throwable var7) {
                    LogUtil.w("readObjectFromFile", var7);
                } finally {
                    IOUtil.closeIO(ois);
                }
            }
        }

        return null;
    }

    // 关闭流
    public static void closeIO(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            } catch (IOException e) {
                LogUtil.w("closeIO" + e);
            }
        }
    }
}
