package com.easefun.polyvsdk.sub.auxilliary;

// 检查并抛出运行时的异常
public class CheckRuntime {

    public static <T> T checkNotNull(String message, T value) {
        if (value == null) {
            throw new NullPointerException(message + " is null");
        }
        return value;
    }

    public static int checkRange_less0(String message, int value) {
        if (value < 0) {
            throw new IllegalArgumentException(message + " must be greater than or equal to 0");
        }
        return value;
    }

    public static int checkRange_lessequal0(String message, int value) {
        if (value <= 0) {
            throw new IllegalArgumentException(message + " must be greater than zero");
        }
        return value;
    }
}
