package com.easefun.polyvsdk.screenshot;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaScannerConnection;

import com.easefun.polyvsdk.PolyvDevMountInfo;
import com.easefun.polyvsdk.PolyvSDKClient;
import com.easefun.polyvsdk.Video;
import com.easefun.polyvsdk.Video.HlsSpeedType;
import com.easefun.polyvsdk.ijk.IjkVideoView;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 网络截取图片的类，请使用{@link com.easefun.polyvsdk.sub.screenshot.PolyvScreenShot}代替。
 *@see com.easefun.polyvsdk.sub.screenshot.PolyvScreenShot
 */
@Deprecated
public class PolyvScreenshot implements ScreenshotException {
	private static final String SCREENSHOTDIR = "/polyvscreenshot";
	private static final String URLPATH = "http://go.polyv.net/snapshot/videoimage.php";
	private String savePath;
	private long currentPosition;

	/**
	 * 设置截图文件的保存路径
	 * 
	 * @param savePath
	 */
	public void setSavePath(String savePath) {
		this.savePath = savePath;
	}

	/**
	 * 监听器
	 *
	 */
	public interface ScreenshotListener {
		public void fail(int category);

		public void success(String filepath);
	}

	private ScreenshotListener screenshotListener;

	/**
	 * 设置监听器
	 * 
	 * @param screenshotListener
	 */
	public void setScreenshotListener(ScreenshotListener screenshotListener) {
		this.screenshotListener = screenshotListener;
	}

	private void callFail(int category) {
		if (screenshotListener != null)
			screenshotListener.fail(category);
	}

	private void callSuccess(String filepath) {
		if (screenshotListener != null)
			screenshotListener.success(filepath);
	}

	public static byte[] md5(String data) {
		return md5(getBytesUtf8(data));
	}

	public static byte[] getBytesUtf8(String string) {
		return getBytes(string, Charset.forName("UTF-8"));
	}

	private static byte[] getBytes(String string, Charset charset) {
		return string == null ? null : string.getBytes(charset);
	}

	public static byte[] md5(byte[] data) {
		return getMd5Digest().digest(data);
	}

	public static MessageDigest getMd5Digest() {
		return getDigest("MD5");
	}

	public static MessageDigest getDigest(String algorithm) {
		try {
			return MessageDigest.getInstance(algorithm);
		} catch (NoSuchAlgorithmException var2) {
			throw new IllegalArgumentException(var2);
		}
	}

	public static char[] encodeHex(byte[] data) {
		return encodeHex(data, true);
	}

	private static final char[] DIGITS_LOWER;
	private static final char[] DIGITS_UPPER;

	static {
		DIGITS_LOWER = new char[] { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };
		DIGITS_UPPER = new char[] { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };
	}

	public static char[] encodeHex(byte[] data, boolean toLowerCase) {
		return encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
	}

	protected static char[] encodeHex(byte[] data, char[] toDigits) {
		int l = data.length;
		char[] out = new char[l << 1];
		int i = 0;

		for (int j = 0; i < l; ++i) {
			out[j++] = toDigits[(240 & data[i]) >>> 4];
			out[j++] = toDigits[15 & data[i]];
		}

		return out;
	}

	private byte[] getBytes(InputStream is) throws IOException {
		ByteArrayOutputStream outstream = new ByteArrayOutputStream();
		byte[] buffer = new byte[1024];
		int len = -1;
		while ((len = is.read(buffer)) != -1) {
			outstream.write(buffer, 0, len);
		}
		outstream.close();
		return outstream.toByteArray();
	}

	/**
	 * 截图
	 * 
	 * @param ijkVideoView
	 * @param context
	 * @param isupdate
	 *            是否要更新至媒体库
	 */
	public void screenshot(IjkVideoView ijkVideoView, final Context context, final boolean isupdate) {
		int position = ijkVideoView.getCurrentPosition();
		HlsSpeedType hlsSpeedType = ijkVideoView.getHlsSpeedType();
		long max = (long) Math.floor(ijkVideoView.getDuration() / 1000.0);
		currentPosition = Math.round(position / 1000.0);
		if (hlsSpeedType == HlsSpeedType.SPEED_1_5X)
			currentPosition = (long) (currentPosition * 1.5);
		if (currentPosition > max && hlsSpeedType != HlsSpeedType.SPEED_1_5X)
			currentPosition = max;
		StringBuilder sb = new StringBuilder();
		Video video = ijkVideoView.getVideo();
		if (video == null) {
			callFail(GETVIDEO_FAIL);
			return;
		}
		final String vid = video.getVid();
		final int dfNum = video.getDfNum();
		sb.append(vid).append(dfNum).append(currentPosition).append("polyvsnapshot");
		final String sign = new String(encodeHex(md5(sb.toString())));
		new Thread(new Runnable() {
			public void run() {
				FileOutputStream fos = null;
				StringBuilder sb1 = new StringBuilder();
				sb1.append("?vid=").append(vid).append("&level=").append(dfNum).append("&second=")
						.append(currentPosition).append("&sign=").append(sign);
				try {
					URL url = new URL(URLPATH + sb1.toString());
					HttpURLConnection conn = (HttpURLConnection) url.openConnection();
					conn.setConnectTimeout(30000);
					conn.setReadTimeout(15000);
					conn.setRequestMethod("GET");
					if (conn.getResponseCode() == 200) {
						byte[] datas = getBytes(conn.getInputStream());
						Bitmap bitmap = BitmapFactory.decodeByteArray(datas, 0, datas.length);
						if (bitmap == null) {
							callFail(DATA_EXCEPTION);
							return;
						}
						if (savePath == null) {
							File downloadDir = PolyvSDKClient.getInstance().getDownloadDir();
							PolyvDevMountInfo.getInstance().mkdirs(downloadDir);
							String downloadStr = downloadDir.getAbsolutePath();
							String ssDir = downloadStr.substring(0, downloadStr.lastIndexOf("/")) + SCREENSHOTDIR;
							savePath = ssDir;
						}
						File ssDirFile = new File(savePath);
						if (!ssDirFile.exists())
							ssDirFile.mkdirs();
						StringBuilder sb2 = new StringBuilder();
						sb2.append("polyv_").append(vid).append("_")
								.append(new SimpleDateFormat("yyyyMMddkkmmss").format(new Date())).append(".jpg");
						fos = new FileOutputStream(new File(savePath, sb2.toString()));
						boolean result = bitmap.compress(Bitmap.CompressFormat.JPEG, 100, fos);
						// 由于上面的方法不会抛出异常，故作以下判断
						File ssFile = new File(savePath, sb2.toString());
						if ((ssFile.exists() && ssFile.length() == 0) || !result) {
							callFail(STORAGE_NOT_ENOUGH);
							return;
						}
						String filepath = savePath + "/" + sb2.toString();
						callSuccess(filepath);
						// 截图成功后发送sd卡就绪广播
						if (isupdate)
							MediaScannerConnection.scanFile(context.getApplicationContext(), new String[] { filepath },
									null, null);
					} else {
						callFail(RESPONSE_FAIL);
					}
				} catch (MalformedURLException e) {
					e.printStackTrace();
				} catch (FileNotFoundException e) {
					e.printStackTrace();
					callFail(CREATE_FILE_FAIL);
				} catch (IOException e) {
					e.printStackTrace();
					callFail(NETWORK_EXCEPTION);
				} finally {
					if (fos != null)
						try {
							fos.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
				}
			}
		}).start();
	}
}
