package com.easefun.polyvsdk.danmaku;

import java.util.Locale;

import master.flame.danmaku.danmaku.model.BaseDanmaku;

/**
 * 弹幕信息转换的工具类
 *
 */
public class DanmakuTool {

	private static String generateTime(long milliseconds) {
		int totalSeconds = (int) (milliseconds / 1000);

		int seconds = totalSeconds % 60;
		int minutes = (totalSeconds / 60) % 60;
		int hours = totalSeconds / 3600;

		if (hours > 0) {
			return String.format(Locale.US, "%02d:%02d:%02d", hours, minutes, seconds).toString();
		} else {
			return String.format(Locale.US, "%02d:%02d:%02d", 0, minutes, seconds).toString();
		}
	}

	/**
	 * 将秒转化为00:00:00格式的时间
	 * 
	 * @param second
	 * @return
	 */
	public static String secondToOriginal(String second) {
		return generateTime(Long.parseLong(second) * 1000);
	}

	/**
	 * 将弹幕类型转化为发送时的类型
	 * 
	 * @param fontMode
	 * @return
	 */
	public static String fontModeToOriginal(String fontMode) {
		if (fontMode.equals(BaseDanmaku.TYPE_FIX_TOP + ""))
			return "top";
		else if (fontMode.equals(BaseDanmaku.TYPE_FIX_BOTTOM + ""))
			return "bottom";
		else
			return "roll";
	}

	/**
	 * 将0xFFFFF类型的整型颜色转化为0xFFFFFF
	 * 
	 * @param fontColor
	 * @return
	 */
	public static String fontColorToOriginal(int fontColor) {
		return "0x" + Integer.toHexString(fontColor).toUpperCase();
	}

	/**
	 * 将rgb转为argb,如0xFFFFFF转为0xFFFFFFFF
	 * 
	 * @param fontColor
	 * @return
	 */
	public static String fontColorToRGB(String fontColor) {
		return "0xFF" + fontColor.substring(2);
	}

	/**
	 * 将01:03:05格式的时间转化为秒
	 * 
	 * @param time
	 * @return
	 */
	public static String timeToSecond(String time) {
		if (time.equals("0"))
			time = "00:00:00";
		String str[] = time.split(":");
		int hour = Integer.parseInt(str[0]);
		int minute = Integer.parseInt(str[1]);
		int seconds = Integer.parseInt(str[2]);
		return hour * 3600 + minute * 60 + seconds + "";
	}

	/**
	 * 将弹幕类型转化为解析器可以识别的类型
	 * 
	 * @param fontMode
	 * @return
	 */
	public static int fontModeToCanResolve(String fontMode) {
		if (fontMode.equals("top"))
			return BaseDanmaku.TYPE_FIX_TOP;
		else if (fontMode.equals("bottom"))
			return BaseDanmaku.TYPE_FIX_BOTTOM;
		else
			return BaseDanmaku.TYPE_SCROLL_RL;
	}

	/**
	 * 将argb转为rgb,如0xFFFFFFFF转为0xFFFFFF
	 * 
	 * @param fontColor
	 * @return
	 */
	public static String fontColorToRGB(int fontColor) {
		String hex = Integer.toHexString(fontColor);
		if (hex.length() < "FFFFFFFF".length()) {
			return "0xFFFFFF";
		} else {
			return "0x" + hex.substring(2).toUpperCase();
		}
	}

	/**
	 * 将弹幕颜色转化为解析器可以识别的类型,如0xFFFFFF转为整型
	 * 
	 * @param fontColor
	 * @return
	 */
	public static int fontColorToCanResolveInt(String fontColor) {
		return Integer.parseInt(fontColor.substring(2), 16);
	}

	/**
	 * 将弹幕颜色转化为解析器可以识别的类型,如0xFFFFFF转为整型
	 * 
	 * @param fontColor
	 * @return
	 */
	public static String fontColorToCanResolve(String fontColor) {
		return Integer.parseInt(fontColor.substring(2), 16) + "";
	}
}
