package com.easefun.polyvsdk.danmaku;

import com.easefun.polyvsdk.danmaku.DanmakuNewMsg.NewMsgListener;

import java.util.List;

import master.flame.danmaku.controller.IDanmakuView;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;

public class DanmakuLiveManager {
	private NewDanmakuListener newDanmakuListener;
	private DanmakuNewMsg danmakuNewMsg;
	private DanmakuManager danmakuManager;
	private boolean noget = false;
	// 第二次获取成功的时候才显示
	private boolean isshow = false;

	/**
	 * 不再获取
	 */
	public void release() {
		this.noget = true;
	}

	public DanmakuLiveManager() {
		danmakuNewMsg = new DanmakuNewMsg(null);
		danmakuManager = new DanmakuManager();
	}

	/**
	 * 设置监听器
	 */
	public void setNewDanmakuListener(NewDanmakuListener newDanmakuListener) {
		this.newDanmakuListener = newDanmakuListener;
	}

	/**
	 * 新弹幕监听器
	 */
	public interface NewDanmakuListener {
		public void success(List<DanmakuInfo> lists);

		public void fail(int category);
	}

	private void callSuccess(List<DanmakuInfo> lists) {
		if (newDanmakuListener != null)
			newDanmakuListener.success(lists);
	}

	private void callFail(int category) {
		if (newDanmakuListener != null)
			newDanmakuListener.fail(category);
	}

	/**
	 * 获取新弹幕和显示
	 * 
	 * @param vid
	 * @param limit
	 * @param mDanmakuView
	 * @param mParser
	 * @param mContext
	 */
	public void getNewDanmakuAndShow(final String vid, final int limit, final IDanmakuView mDanmakuView,
			final BaseDanmakuParser mParser, final DanmakuContext mContext) {
		// 先获取一遍旧的弹幕
		danmakuNewMsg.setNewMsgListener(new NewMsgListener() {

			@Override
			public void success(List<DanmakuInfo> lists) {
				if (!isshow) {
					isshow = !isshow;
					return;
				}
				callSuccess(lists);
				for (DanmakuInfo danmakuInfo : lists) {
					danmakuManager.setSendDanmaku(danmakuInfo);
					danmakuManager.showDanmaku(mDanmakuView, mParser, mContext, false, true);
				}
			}

			@Override
			public void fail(int category) {
				callFail(category);
			}
		});
		while (!noget) {
			if (!isshow)
				danmakuNewMsg.getNewDanmaku(vid, 0);
			else
				danmakuNewMsg.getNewDanmaku(vid, limit);
		}
	}
}
