package com.easefun.polyvsdk.danmaku;

import android.graphics.Color;

public class DanmakuInfo implements Comparable<DanmakuInfo> {
	private String time;
	private String fontMode;
	private int fontSize;
	private int fontColor;
	private String timestamp;
	private String vid;
	private String userId;
	private String danmakuId;
	private String msg;

	/**
	 * 直播弹幕的构造器
	 * 
	 * @param vid
	 *            视频id
	 * @param msg
	 *            弹幕信息
	 */
	public DanmakuInfo(String vid, String msg) {
		this(vid, msg, "00:00:00", 24, "roll", Color.WHITE);
	}

	/**
	 * 
	 * @param vid
	 *            视频id
	 * @param msg
	 *            弹幕信息
	 * @param time
	 *            弹幕出现时间 格式：01:03:05
	 */
	public DanmakuInfo(String vid, String msg, String time) {
		this(vid, msg, time, 18, "roll", Color.WHITE);
	}

	/**
	 * @param vid
	 *            视频id
	 * @param msg
	 *            弹幕信息，不能为空
	 * @param time
	 *            弹幕出现时间 格式：01:03:05
	 * @param fontSize
	 *            字体的大小 如：16,18,24 默认为18
	 * @param fontMode
	 *            弹幕的样式 取值有：top，bottom，roll 默认为roll
	 * @param fontColor
	 *            字体颜色 默认为：0xFFFFFF
	 */
	public DanmakuInfo(String vid, String msg, String time, int fontSize, String fontMode, int fontColor) {
		this(vid, msg, time, fontSize, fontMode, fontColor, "1", "1", "1");
	}

	public DanmakuInfo(String vid, String msg, String time, int fontSize, String fontMode, int fontColor,
			String timestamp, String userId, String danmakuId) {
		this.time = time;
		this.fontMode = fontMode;
		this.fontSize = fontSize;
		this.fontColor = fontColor;
		this.timestamp = timestamp;
		this.vid = vid;
		this.userId = userId;
		this.danmakuId = danmakuId;
		this.msg = msg;
	}

	public String getTime() {
		return time;
	}

	public void setTime(String time) {
		this.time = time;
	}

	public String getFontMode() {
		return fontMode;
	}

	public void setFontMode(String fontMode) {
		this.fontMode = fontMode;
	}

	public int getFontSize() {
		return fontSize;
	}

	public void setFontSize(int fontSize) {
		this.fontSize = fontSize;
	}

	public int getFontColor() {
		return fontColor;
	}

	public void setFontColor(int fontColor) {
		this.fontColor = fontColor;
	}

	public String getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(String timestamp) {
		this.timestamp = timestamp;
	}

	public String getVid() {
		return vid;
	}

	public void setVid(String vid) {
		this.vid = vid;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getDanmakuId() {
		return danmakuId;
	}

	public void setDanmakuId(String danmakuId) {
		this.danmakuId = danmakuId;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	/**
	 * <table border="1">
	 * <tr>
	 * <td>出现弹幕的时间，弹幕样式，字体大小，字体颜色，发送弹幕的时间，视频的id，用户的id，弹幕的id</td>
	 * </tr>
	 * </table>
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append(time).append(",").append(fontMode).append(",").append(fontSize).append(",").append(fontColor)
				.append(",").append(timestamp).append(",").append(vid).append(",").append(userId).append(",")
				.append(danmakuId);
		return sb.toString();
	}

	@Override
	public int compareTo(DanmakuInfo another) {
		if (another == null)
			return -1;
		if (this.getDanmakuId().equals(another.getDanmakuId())) {
			if (this.getFontColor() == (another.getFontColor())) {
				if (this.getFontMode().equals(another.getFontMode())) {
					if (this.getFontSize() == (another.getFontSize())) {
						if (this.getMsg().equals(another.getMsg())) {
							if (this.getTime().equals(another.getTime())) {
								if (this.getTimestamp().equals(another.getTimestamp())) {
									if (this.getUserId().equals(another.getUserId())) {
										if (this.getVid().equals(another.getVid())) {
											return 0;
										}
									}
								}
							}
						}
					}
				}
			}
		}
		return -1;
	}

}
