/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.video;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.easefun.polyvsdk.PolyvBitRate;
import com.easefun.polyvsdk.PolyvQOSAnalytics;
import com.easefun.polyvsdk.PolyvSDKClient;
import com.easefun.polyvsdk.PolyvSDKUtil;
import com.easefun.polyvsdk.Video;
import com.easefun.polyvsdk.log.PolyvLogFile;
import com.easefun.polyvsdk.video.b;
import com.easefun.polyvsdk.vo.PolyvVideoVO;
import com.easefun.polyvsdk.vo.d;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class PolyvVideoUtil {
    private static final String TAG = PolyvVideoUtil.class.getSimpleName();
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public static int validateM3U8Video(String videoId, int bitRate) {
        return PolyvVideoUtil.validateM3U8Video(videoId, bitRate, Video.HlsSpeedType.SPEED_1X);
    }

    @Deprecated
    public static int validateM3U8Video(String videoId, int bitRate, Video.HlsSpeedType hlsSpeedType) {
        File file = PolyvSDKClient.getInstance().getDownloadDir();
        if (file == null) {
            return 2;
        }
        if (!file.isDirectory()) {
            return 2;
        }
        if (!PolyvSDKUtil.validateVideoId(videoId)) {
            return 2;
        }
        int n2 = videoId.lastIndexOf("_");
        String string = videoId.substring(0, n2);
        String string2 = file.getAbsolutePath();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2).append(File.separator).append(string).append("_").append(bitRate).append(File.separator).append(string).append("_").append(bitRate).append(".m3u8");
        File file2 = new File(stringBuilder.toString());
        if (!file2.exists()) {
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append(string2).append(File.separator);
            if (hlsSpeedType == Video.HlsSpeedType.SPEED_1_5X) {
                stringBuilder.append(hlsSpeedType.getName()).append("_");
            }
            stringBuilder.append(string).append("_").append(bitRate).append(".m3u8");
            file2 = new File(stringBuilder.toString());
        }
        if (file2.exists()) {
            String string3 = PolyvSDKUtil.getFile2String(file2);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return 3;
            }
            List<String> list = PolyvVideoUtil.getTSFileList(string3, videoId, bitRate, hlsSpeedType);
            if (list.isEmpty()) {
                return 4;
            }
            for (String object : list) {
                File file3 = new File(object);
                if (file3.exists()) continue;
                return 5;
            }
            if (string3.contains("EXT-X-KEY")) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(string2).append(File.separator).append(string).append("_").append(bitRate).append(File.separator).append(string).append("_").append(bitRate).append(".key");
                File file3 = new File(stringBuilder2.toString());
                if (!file3.exists()) {
                    stringBuilder2.delete(0, stringBuilder2.length());
                    stringBuilder2.append(string2).append(File.separator);
                    if (hlsSpeedType == Video.HlsSpeedType.SPEED_1_5X) {
                        stringBuilder2.append(hlsSpeedType.getName()).append("_");
                    }
                    stringBuilder2.append(string).append("_").append(bitRate).append(".key");
                    File file4 = new File(stringBuilder2.toString());
                    if (!file4.exists()) {
                        return 6;
                    }
                }
            }
            return 1;
        }
        return 2;
    }

    @NonNull
    private static List<String> getTSFileList(String m3u8data, String videoId, int bitRate, Video.HlsSpeedType hlsSpeedType) {
        Pattern pattern = Pattern.compile(".*\\.ts");
        Matcher matcher = pattern.matcher(m3u8data);
        String string = videoId.substring(0, videoId.indexOf("_")) + "_" + bitRate;
        String string2 = PolyvSDKClient.getInstance().getDownloadDir().getAbsolutePath();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            String string3 = matcher.group();
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append(string2).append(File.separator);
            if (hlsSpeedType == Video.HlsSpeedType.SPEED_1_5X) {
                stringBuilder.append(hlsSpeedType.getName()).append("_");
            }
            if (!string3.contains(string + "/")) {
                stringBuilder.append(string).append(File.separator);
            }
            stringBuilder.append(string3);
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    @Nullable
    public static File validateMP4Video(String videoId, int bitRate) {
        File file = PolyvSDKClient.getInstance().getDownloadDir();
        if (file == null) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        if (!PolyvSDKUtil.validateVideoId(videoId)) {
            return null;
        }
        int n2 = videoId.lastIndexOf("_");
        String string = videoId.substring(0, n2);
        File file2 = new File(file.getAbsolutePath() + File.separator + string + "_" + bitRate + ".mp4");
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    @Nullable
    public static File validateVideo(String videoId, int bitRate) {
        File file = PolyvSDKClient.getInstance().getDownloadDir();
        if (file == null) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        if (!PolyvSDKUtil.validateVideoId(videoId)) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        if (fileArray.length == 0) {
            return null;
        }
        int n2 = videoId.lastIndexOf("_");
        String string = videoId.substring(0, n2);
        String string2 = string + "_" + bitRate;
        for (File file2 : fileArray) {
            String string3;
            int n3;
            String string4;
            String string5;
            if (file2.isDirectory() || !(string5 = file2.getName()).contains(".") || "m3u8".equals(string4 = string5.substring((n3 = string5.lastIndexOf(".")) + 1)) || "key".equals(string4) || "json".equals(string4) || !string2.equals(string3 = string5.substring(0, n3))) continue;
            return file2;
        }
        return null;
    }

    @Nullable
    public static File validateTmpVideo(String videoId, int bitRate) {
        File file = PolyvSDKClient.getInstance().getDownloadDir();
        if (file == null) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        if (!PolyvSDKUtil.validateVideoId(videoId)) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        if (fileArray.length == 0) {
            return null;
        }
        int n2 = videoId.lastIndexOf("_");
        String string = videoId.substring(0, n2);
        String string2 = string + "_" + bitRate;
        for (File file2 : fileArray) {
            String string3;
            String string4;
            if (file2.isDirectory() || (string4 = file2.getName()).contains(".") || !string2.equals(string3 = string4)) continue;
            return file2;
        }
        return null;
    }

    static b loadLocalVideo(String videoId, int bitRate, Video.HlsSpeedType hlsSpeedType) {
        File file = PolyvVideoUtil.validateVideo(videoId, bitRate);
        if (file != null) {
            return new b(1, PolyvVideoUtil.getLocalMP4Uri(file));
        }
        int n2 = PolyvVideoUtil.validateM3U8Video(videoId, bitRate, hlsSpeedType);
        switch (n2) {
            case 1: {
                return new b(1, PolyvVideoUtil.getLocalM3U8Uri(videoId, bitRate, hlsSpeedType));
            }
            case 2: {
                return new b(2, null);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new b(3, null);
            }
        }
        return new b(3, null);
    }

    private static String getLocalMP4Uri(File file) {
        return file.getAbsolutePath();
    }

    private static String getLocalM3U8Uri(String videoId, int bitRate, Video.HlsSpeedType hlsSpeedType) {
        int n2 = videoId.lastIndexOf("_");
        String string = videoId.substring(0, n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PolyvSDKClient.getInstance().getDownloadDir().getAbsolutePath()).append(File.separator).append(string).append("_").append(bitRate).append(File.separator).append(string).append("_").append(bitRate).append(".m3u8");
        File file = new File(stringBuilder.toString());
        if (!file.exists()) {
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append(PolyvSDKClient.getInstance().getDownloadDir().getAbsolutePath()).append(File.separator);
            if (hlsSpeedType == Video.HlsSpeedType.SPEED_1_5X) {
                stringBuilder.append(hlsSpeedType.getName()).append("_");
            }
            stringBuilder.append(string).append("_").append(bitRate).append(".m3u8");
            file = new File(stringBuilder.toString());
        }
        return file.getAbsolutePath();
    }

    @Nullable
    static d requestToken(@NonNull String videoId, @NonNull String viewerId, @NonNull String viewerName, @NonNull String viewerParam, long timestamp, ArrayList<String> exceptionList) {
        String string = PolyvSDKClient.getInstance().getUserId();
        d d2 = PolyvVideoUtil.getToken("https://hls.videocc.net/service/v1/token", string, videoId, viewerId, viewerName, viewerParam, timestamp, exceptionList);
        if (d2 == null) {
            d2 = PolyvVideoUtil.getToken("http://hls.videocc.net/service/v1/token", string, videoId, viewerId, viewerName, viewerParam, timestamp, exceptionList);
        }
        return d2;
    }

    private static d getToken(String url, String userId, String videoId, String viewerId, String viewerName, String viewerParam, long timestamp, ArrayList<String> exceptionList) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            JSONObject jSONObject;
            stringBuilder.delete(0, stringBuilder.length());
            if (!TextUtils.isEmpty((CharSequence)viewerParam)) {
                stringBuilder.append("extraParams").append(viewerParam);
            }
            stringBuilder.append("ts").append(timestamp).append("userId").append(userId).append("videoId").append(videoId);
            if (!TextUtils.isEmpty((CharSequence)viewerId)) {
                stringBuilder.append("viewerId").append(viewerId);
            }
            if (!TextUtils.isEmpty((CharSequence)viewerName)) {
                stringBuilder.append("viewerName").append(viewerName);
            }
            String string = PolyvSDKClient.getInstance().getTokenSignToString(stringBuilder.toString()).toUpperCase();
            stringBuilder2.delete(0, stringBuilder2.length());
            stringBuilder2.append("userId=").append(userId).append("&videoId=").append(videoId).append("&ts=").append(timestamp);
            if (!TextUtils.isEmpty((CharSequence)viewerName)) {
                stringBuilder2.append("&viewerName=").append(viewerName);
            }
            if (!TextUtils.isEmpty((CharSequence)viewerParam)) {
                stringBuilder2.append("&extraParams=").append(viewerParam);
            }
            if (!TextUtils.isEmpty((CharSequence)viewerId)) {
                stringBuilder2.append("&viewerId=").append(viewerId);
            }
            stringBuilder2.append("&sign=").append(string);
            String string2 = PolyvSDKUtil.postUrl2String(url, stringBuilder2.toString(), 10000, 10000, exceptionList, null);
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                if (exceptionList == null) continue;
                exceptionList.add(PolyvSDKUtil.getExceptionFullMessage(jSONException));
                continue;
            }
            int n2 = jSONObject.optInt("code", 0);
            if (n2 != 200) {
                if (exceptionList == null) continue;
                exceptionList.add(String.format(Locale.getDefault(), "error code is %d, message is %s", n2, jSONObject.optString("message", "")));
                continue;
            }
            d d2 = d.a(jSONObject);
            if (d2.d() == null) {
                Log.e((String)TAG, (String)"token data vo is null");
                if (exceptionList == null) continue;
                exceptionList.add("token data vo is null");
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)d2.d().a())) {
                if (exceptionList == null) continue;
                exceptionList.add("token value is null");
                continue;
            }
            return d2;
        }
        return null;
    }

    static int getVideoType(PolyvVideoVO videoVO) {
        if ("1".equals(videoVO.getKeepsource())) {
            return 4;
        }
        if (videoVO.getSeed() == 0 && videoVO.getFullmp4() == 0) {
            return 1;
        }
        if (videoVO.getSeed() == 0 && videoVO.getFullmp4() == 1) {
            return 2;
        }
        if (videoVO.getSeed() == 1 || videoVO.getFullmp4() == 1) {
            return 3;
        }
        return 1;
    }

    static void playerErrorM3U8Statistics(final String pid, final Context mContext, PolyvVideoVO video, PolyvBitRate bitRate, Video.HlsSpeedType hlsSpeedType, final int frameworkErr, final int implErr, final String dataSource) {
        if (video == null) {
            return;
        }
        int n2 = bitRate.getIndexByVideoUrlList();
        String string = "";
        switch (hlsSpeedType) {
            case SPEED_1X: {
                string = video.getHls().get(n2);
                break;
            }
            case SPEED_1_5X: {
                if (video.getHls15X().size() <= bitRate.getNum()) break;
                string = video.getHls15X().get(n2);
            }
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            PolyvQOSAnalytics.error(pid, video.getVid(), "video_type_on_error_listener", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), String.format(Locale.getDefault(), "m3u8 statistics path is null impl_err:%d framework_err:%d speed:%s", implErr, frameworkErr, hlsSpeedType.getName()), dataSource);
            return;
        }
        final String string2 = video.getVid();
        final String string3 = string;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                Comparable<ByteBuffer> comparable;
                Object object2;
                ArrayList<String> arrayList;
                Object object3;
                Closeable closeable;
                Closeable closeable2;
                Closeable closeable3;
                Object object4;
                URI uRI;
                try {
                    uRI = new URI(string3);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(uRISyntaxException, -1));
                    PolyvQOSAnalytics.error(pid, string2, "video_type_on_error_listener", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), String.format(Locale.getDefault(), "%s implErr[%d] frameworkErr[%d]", dataSource, implErr, frameworkErr), String.format("statistics m3u8 path error:%s", string3));
                    return;
                }
                boolean bl = PolyvSDKClient.getInstance().isServiceStart();
                if (!bl) {
                    PolyvQOSAnalytics.error(pid, string2, "video_type_on_error_listener", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), String.format(Locale.getDefault(), "%s implErr[%d] frameworkErr[%d]", dataSource, implErr, frameworkErr), "service not start");
                    return;
                }
                String string = uRI.getHost();
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec("ping -c 1 " + string);
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (process == null) {
                    stringBuilder.append("[ping error]");
                } else {
                    String string22;
                    object4 = null;
                    closeable3 = null;
                    closeable2 = null;
                    closeable = null;
                    try {
                        object4 = process.getErrorStream();
                        closeable3 = Channels.newChannel((InputStream)object4);
                        closeable2 = new ByteArrayOutputStream();
                        closeable = Channels.newChannel((OutputStream)closeable2);
                        object3 = ByteBuffer.allocate(4096);
                        while (true) {
                            int n2;
                            if ((n2 = closeable3.read((ByteBuffer)object3)) == -1) break;
                            ((ByteBuffer)object3).flip();
                            closeable.write((ByteBuffer)object3);
                            ((ByteBuffer)object3).clear();
                        }
                        ((ByteBuffer)object3).clear();
                        string22 = ((ByteArrayOutputStream)closeable2).toString();
                        if (string22.length() > 130) {
                            string22 = string22.substring(0, 130);
                        }
                        stringBuilder.append("[ping error msg=").append(string22).append("]");
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                    }
                    finally {
                        if (closeable != null) {
                            try {
                                closeable.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (closeable2 != null) {
                            try {
                                ((ByteArrayOutputStream)closeable2).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (closeable3 != null) {
                            try {
                                closeable3.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (object4 != null) {
                            try {
                                ((InputStream)object4).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    try {
                        object4 = process.getInputStream();
                        closeable3 = Channels.newChannel((InputStream)object4);
                        closeable2 = new ByteArrayOutputStream();
                        closeable = Channels.newChannel((OutputStream)closeable2);
                        object3 = ByteBuffer.allocate(4096);
                        while (true) {
                            int n3;
                            if ((n3 = closeable3.read((ByteBuffer)object3)) == -1) break;
                            ((ByteBuffer)object3).flip();
                            closeable.write((ByteBuffer)object3);
                            ((ByteBuffer)object3).clear();
                        }
                        ((ByteBuffer)object3).clear();
                        string22 = ((ByteArrayOutputStream)closeable2).toString();
                        if (string22.length() > 130) {
                            string22 = string22.substring(0, 130);
                        }
                        stringBuilder.append("[").append(string22).append("]");
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                    }
                    finally {
                        if (closeable != null) {
                            try {
                                closeable.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (closeable2 != null) {
                            try {
                                ((ByteArrayOutputStream)closeable2).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (closeable3 != null) {
                            try {
                                closeable3.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (object4 != null) {
                            try {
                                ((InputStream)object4).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                stringBuilder.append("[req=").append(string3).append(",");
                object4 = "";
                closeable3 = null;
                closeable2 = null;
                closeable = null;
                object3 = null;
                try {
                    long l2 = System.currentTimeMillis();
                    arrayList = new URL(string3);
                    object2 = (HttpURLConnection)((URL)((Object)arrayList)).openConnection();
                    ((URLConnection)object2).setConnectTimeout(30000);
                    ((URLConnection)object2).setReadTimeout(45000);
                    ((HttpURLConnection)object2).setRequestMethod("GET");
                    ((URLConnection)object2).connect();
                    int n4 = ((HttpURLConnection)object2).getResponseCode();
                    stringBuilder.append("res=").append(n4).append(",");
                    closeable3 = ((URLConnection)object2).getInputStream();
                    closeable2 = Channels.newChannel((InputStream)closeable3);
                    closeable = new ByteArrayOutputStream();
                    object3 = Channels.newChannel((OutputStream)closeable);
                    comparable = ByteBuffer.allocate(4096);
                    while (true) {
                        int n5;
                        if ((n5 = closeable2.read((ByteBuffer)comparable)) == -1) break;
                        ((ByteBuffer)comparable).flip();
                        object3.write((ByteBuffer)comparable);
                        ((ByteBuffer)comparable).clear();
                    }
                    ((ByteBuffer)comparable).clear();
                    long l3 = System.currentTimeMillis();
                    stringBuilder.append("time=").append(l3 - l2).append("ms]");
                    object4 = new String(((ByteArrayOutputStream)closeable).toByteArray(), "UTF-8");
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                    object = new StringBuilder();
                    ((StringBuilder)object).append("http://prtas.videocc.net/test_event").append("?pid=").append(pid).append("&vid=").append(string2).append("&desc=").append(PolyvSDKUtil.getExceptionFullMessage(exception));
                    PolyvVideoUtil.sendHttpRequest(((StringBuilder)object).toString());
                }
                finally {
                    if (object3 != null) {
                        try {
                            object3.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (closeable != null) {
                        try {
                            ((ByteArrayOutputStream)closeable).close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (closeable2 != null) {
                        try {
                            closeable2.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (closeable3 != null) {
                        try {
                            ((InputStream)closeable3).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)object4)) {
                    Pattern pattern = Pattern.compile("https?://.*\\.ts");
                    object = pattern.matcher((CharSequence)object4);
                    arrayList = "";
                    if (((Matcher)object).find()) {
                        arrayList = ((Matcher)object).group();
                    }
                    if (TextUtils.isEmpty((CharSequence)((Object)arrayList))) {
                        stringBuilder.append("[not ts url]");
                    } else {
                        object2 = ((String)((Object)arrayList)).substring(((String)((Object)arrayList)).lastIndexOf("/"), ((String)((Object)arrayList)).length());
                        File file = mContext.getFilesDir();
                        comparable = new File(file, (String)object2);
                        if (((File)comparable).exists()) {
                            ((File)comparable).delete();
                        }
                        stringBuilder.append("[req=").append((String)((Object)arrayList)).append(",");
                        InputStream inputStream = null;
                        Channel channel = null;
                        FileOutputStream fileOutputStream = null;
                        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
                        try {
                            long l4 = System.currentTimeMillis();
                            URL uRL = new URL((String)((Object)arrayList));
                            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                            httpURLConnection.setConnectTimeout(50000);
                            httpURLConnection.setReadTimeout(50000);
                            httpURLConnection.setRequestMethod("GET");
                            httpURLConnection.connect();
                            int n6 = httpURLConnection.getResponseCode();
                            stringBuilder.append("res=").append(n6).append(",");
                            inputStream = httpURLConnection.getInputStream();
                            channel = Channels.newChannel(inputStream);
                            fileOutputStream = new FileOutputStream((File)comparable);
                            abstractInterruptibleChannel = fileOutputStream.getChannel();
                            ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
                            while (true) {
                                int n7;
                                if ((n7 = channel.read(byteBuffer)) == -1) break;
                                byteBuffer.flip();
                                ((FileChannel)abstractInterruptibleChannel).write(byteBuffer);
                                byteBuffer.clear();
                            }
                            byteBuffer.clear();
                            long l5 = System.currentTimeMillis();
                            stringBuilder.append("time=").append(l5 - l4).append("ms]");
                        }
                        catch (Exception exception) {
                            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                            StringBuilder stringBuilder2 = new StringBuilder();
                            stringBuilder2.append("http://prtas.videocc.net/test_event").append("?pid=").append(pid).append("&vid=").append(string2).append("&desc=").append(PolyvSDKUtil.getExceptionFullMessage(exception));
                            PolyvVideoUtil.sendHttpRequest(stringBuilder2.toString());
                        }
                        finally {
                            if (abstractInterruptibleChannel != null) {
                                try {
                                    abstractInterruptibleChannel.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                } else {
                    stringBuilder.append("[m3u8 is empty]");
                }
                String string32 = "";
                try {
                    string32 = URLEncoder.encode(stringBuilder.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string32 = "url encoder error";
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("http://prtas.videocc.net/test_event").append("?pid=").append(pid).append("&vid=").append(string2).append("&desc=").append(string32);
                PolyvVideoUtil.sendHttpRequest(((StringBuilder)object).toString());
                arrayList = new ArrayList<String>();
                arrayList.add(stringBuilder.toString());
                arrayList.add("implErr=" + implErr + ",frameworkErr=" + frameworkErr);
                arrayList.add(dataSource);
                Log.i((String)TAG, (String)stringBuilder.toString());
                PolyvLogFile.extractLogcat2File(pid, string2, null, arrayList);
                PolyvQOSAnalytics.error(pid, string2, "video_type_on_error_listener", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), String.valueOf(implErr), String.valueOf(frameworkErr), dataSource);
            }
        });
        thread.start();
    }

    static void playerErrorMP4Statistics(final String pid, Context mContext, PolyvVideoVO video, PolyvBitRate bitRate, final int frameworkErr, final int implErr, final String dataSource) {
        if (video == null) {
            return;
        }
        final String string = video.getMp4().get(bitRate.getIndexByVideoUrlList());
        final String string2 = video.getVid();
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                Object object2;
                Object object3;
                URI uRI;
                try {
                    uRI = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(uRISyntaxException, -1));
                    PolyvQOSAnalytics.error(pid, string2, "video_type_on_error_listener", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), String.format("%s implErr[%d] frameworkErr[%d]", dataSource, implErr, frameworkErr), String.format("statistics mp4 path error:%s", string));
                    return;
                }
                String string4 = uRI.getHost();
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec("ping -c 1 " + string4);
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("MP4");
                if (process == null) {
                    stringBuilder.append("[ping error]");
                } else {
                    ByteBuffer byteBuffer;
                    object3 = null;
                    object2 = null;
                    object = null;
                    Channel channel = null;
                    try {
                        object3 = process.getErrorStream();
                        object2 = Channels.newChannel((InputStream)object3);
                        object = new ByteArrayOutputStream();
                        channel = Channels.newChannel((OutputStream)object);
                        byteBuffer = ByteBuffer.allocate(4096);
                        while (true) {
                            int n2;
                            if ((n2 = object2.read(byteBuffer)) == -1) break;
                            byteBuffer.flip();
                            channel.write(byteBuffer);
                            byteBuffer.clear();
                        }
                        byteBuffer.clear();
                        String string22 = ((ByteArrayOutputStream)object).toString();
                        if (string22.length() > 130) {
                            string22 = string22.substring(0, 130);
                        }
                        stringBuilder.append("[ping error msg=").append(string22).append("]");
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                    }
                    finally {
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (object != null) {
                            try {
                                ((ByteArrayOutputStream)object).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (object2 != null) {
                            try {
                                object2.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (object3 != null) {
                            try {
                                ((InputStream)object3).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    try {
                        object3 = process.getInputStream();
                        object2 = Channels.newChannel((InputStream)object3);
                        object = new ByteArrayOutputStream();
                        channel = Channels.newChannel((OutputStream)object);
                        byteBuffer = ByteBuffer.allocate(4096);
                        while (true) {
                            int n3;
                            if ((n3 = object2.read(byteBuffer)) == -1) break;
                            byteBuffer.flip();
                            channel.write(byteBuffer);
                            byteBuffer.clear();
                        }
                        byteBuffer.clear();
                        String string3 = ((ByteArrayOutputStream)object).toString();
                        if (string3.length() > 130) {
                            string3 = string3.substring(0, 130);
                        }
                        stringBuilder.append("[").append(string3).append("]");
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                    }
                    finally {
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (object != null) {
                            try {
                                ((ByteArrayOutputStream)object).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (object2 != null) {
                            try {
                                object2.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (object3 != null) {
                            try {
                                ((InputStream)object3).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                object3 = "";
                try {
                    object3 = URLEncoder.encode(stringBuilder.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object3 = "url encoder error";
                }
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("http://prtas.videocc.net/test_event").append("?pid=").append(pid).append("&vid=").append(string2).append("&desc=").append((String)object3);
                PolyvVideoUtil.sendHttpRequest(((StringBuilder)object2).toString());
                object = new ArrayList();
                ((ArrayList)object).add(stringBuilder.toString());
                ((ArrayList)object).add("implErr=" + implErr + ",frameworkErr=" + frameworkErr);
                ((ArrayList)object).add(dataSource);
                Log.i((String)TAG, (String)stringBuilder.toString());
                PolyvLogFile.extractLogcat2File(pid, string2, null, (List<String>)object);
                PolyvQOSAnalytics.error(pid, string2, "video_type_on_error_listener", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), String.valueOf(implErr), String.valueOf(frameworkErr), dataSource);
            }
        });
        thread.start();
    }

    static void statDemand(@NonNull String pid, @NonNull String vid, long flow, int pd, int sd, int cts, int duration, @NonNull String viewerId, @NonNull String param1, @NonNull String param2, @NonNull String param3, @NonNull String param4, @NonNull String param5) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("rtas.net").append(pid).append(vid).append(flow).append(pd).append(cts);
        String string = PolyvSDKUtil.MD5(stringBuilder.toString());
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("http://prtas.videocc.net/v1/view").append("?pid=").append(pid).append("&uid=").append(PolyvSDKClient.getInstance().getUserId()).append("&vid=").append(vid).append("&flow=").append(flow).append("&pd=").append(pd).append("&sd=").append(sd).append("&cts=").append(cts).append("&duration=").append(duration).append("&href=").append("&pn=").append("polyv-android-sdk").append("&pv=").append("2.2.0-20171212").append("&sign=").append(string).append("&sid=").append(PolyvVideoUtil.base64Encoder(viewerId)).append("&param1=").append(PolyvVideoUtil.base64Encoder(param1)).append("&param2=").append(PolyvVideoUtil.base64Encoder(param2)).append("&param3=").append(PolyvVideoUtil.base64Encoder(param3)).append("&param4=").append(PolyvVideoUtil.base64Encoder(param4)).append("&param5=").append(PolyvVideoUtil.base64Encoder(param5));
        PolyvVideoUtil.sendHttpRequest(stringBuilder2.toString());
    }

    private static String base64Encoder(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        return Base64.encodeToString((byte[])str.getBytes(), (int)2);
    }

    private static void sendHttpRequest(final String urlStr) {
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    URL uRL = new URL(urlStr);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setConnectTimeout(10000);
                    httpURLConnection.setReadTimeout(10000);
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.addRequestProperty("User-Agent", "polyv-android-sdk2.2.0-20171212");
                    httpURLConnection.connect();
                    int n2 = httpURLConnection.getResponseCode();
                    Log.d((String)TAG, (String)(urlStr + " responseCode = " + n2));
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                }
            }
        });
    }
}

