/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;

public class PolyvScreenTool {
    private static final int HIDE_STATUSBAR = 1;
    private static final Handler HANDLER = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PolyvScreenTool.reSetStatusBar((Activity)msg.obj);
                }
            }
        }
    };

    private static boolean isLandscape(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    public static void setHideStatusBarListener(final Activity activity, final long millissecond) {
        View view = activity.getWindow().getDecorView();
        view.setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

            public void onSystemUiVisibilityChange(int visibility) {
                if ((visibility & 4) == 0) {
                    Message message = HANDLER.obtainMessage();
                    message.obj = activity;
                    message.what = 1;
                    HANDLER.sendMessageDelayed(message, millissecond);
                }
            }
        });
    }

    public static int[] getNormalWH(Activity activity) {
        if (Build.VERSION.SDK_INT < 14) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            return new int[]{displayMetrics.widthPixels, displayMetrics.heightPixels};
        }
        Point point = new Point();
        WindowManager windowManager = activity.getWindowManager();
        windowManager.getDefaultDisplay().getSize(point);
        return new int[]{point.x, point.y};
    }

    public static void reSetStatusBar(Activity activity) {
        if (PolyvScreenTool.isLandscape((Context)activity)) {
            PolyvScreenTool.hideStatusBar(activity);
        } else {
            PolyvScreenTool.setDecorVisible(activity);
        }
    }

    private static void hideStatusBar(Activity activity) {
        if (Build.VERSION.SDK_INT < 16) {
            activity.getWindow().setFlags(1024, 1024);
        } else {
            View view = activity.getWindow().getDecorView();
            activity.getWindow().setFlags(1024, 1024);
            int n2 = 7172;
            view.setSystemUiVisibility(n2);
        }
    }

    private static void setDecorVisible(Activity activity) {
        if (Build.VERSION.SDK_INT < 16) {
            activity.getWindow().clearFlags(1024);
        } else {
            View view = activity.getWindow().getDecorView();
            activity.getWindow().clearFlags(1024);
            int n2 = 0;
            view.setSystemUiVisibility(n2);
        }
    }
}

