package com.easefun.polyvsdk.vo;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.support.annotation.NonNull;

import com.easefun.polyvsdk.QuestionVO;

/**
 * 问题VO
 * @version 2.0
 * @author TanQu 2016-1-20
 */
public class PolyvQuestionVO {
	/** 问答类型 */
	public static final int TYPE_QUESTION = 0;
	/** 听力类型 */
	public static final int TYPE_AUDITION = 1;
	
	/** 问答题目的id */
	private final String examId;
	/** 用户的id */
	private final String userId;
	/** 视频的id */
	private final String vid;
	/** 问答题目开始显示的时间 */
	private final String showTime;
	/** 时 */
	private final int hours;
	/** 分 */
	private final int minutes;
	/** 秒 */
	private final int seconds;
	/** 问题 */
	private final String question;
	/** 选项列表 */
	private final List<QuestionVO.ChoicesVO> choicesList;
	/** 选项列表 */
	private List<PolyvQuestionChoicesVO> choicesList2;
	/** 答案 */
	private final String answer;
	/** 能否跳过问答 */
	private final boolean skip;
	/** 类型，本类定义的常亮 TYPE_ 开头 */
	private final int type;
	private final String mp3url;
	/** 回答错误后跳回到第几秒 */
	private final int wrongTime;
	/** 回答错误是否提示 */
	private final int wrongShow;
	private final int status;
	/** 创建问答题目的时间 */
	private final long createdTime;
	/** 是否是从下载获取的 */
	private final boolean isFromDownload;
	
	public PolyvQuestionVO(String examId, String userId, String vid, String showTime, int hours, int minutes, int seconds,
			String question, List<QuestionVO.ChoicesVO> choicesList, String answer, boolean skip, int type, String mp3url, int wrongTime,
			int wrongShow, int status, long createdTime, boolean isFromDownload) {
		super();
		this.examId = examId;
		this.userId = userId;
		this.vid = vid;
		this.showTime = showTime;
		this.hours = hours;
		this.minutes = minutes;
		this.seconds = seconds;
		this.question = question;
		this.choicesList = choicesList;
		this.choicesList2 = toPolyvQuestionChoicesVOList(choicesList);
		this.answer = answer;
		this.skip = skip;
		this.type = type;
		this.mp3url = mp3url;
		this.wrongTime = wrongTime;
		this.wrongShow = wrongShow;
		this.status = status;
		this.createdTime = createdTime;
		this.isFromDownload = isFromDownload;
	}

	public String getExamId() {
		return examId;
	}

	public String getUserId() {
		return userId;
	}

	public String getVid() {
		return vid;
	}

	public String getShowTime() {
		return showTime;
	}

	public int getHours() {
		return hours;
	}

	public int getMinutes() {
		return minutes;
	}

	public int getSeconds() {
		return seconds;
	}

	public String getQuestion() {
		return question;
	}

	public List<QuestionVO.ChoicesVO> getChoicesList() {
		return choicesList;
	}

	public List<PolyvQuestionChoicesVO> getChoicesList2() {
		return choicesList2;
	}

	public String getAnswer() {
		return answer;
	}

	public boolean isSkip() {
		return skip;
	}

	public int getType() {
		return type;
	}

	public String getMp3url() {
		return mp3url;
	}

	public int getWrongTime() {
		return wrongTime;
	}

	public int getWrongShow() {
		return wrongShow;
	}

	public int getStatus() {
		return status;
	}

	public long getCreatedTime() {
		return createdTime;
	}

	public boolean isFromDownload() {
		return isFromDownload;
	}

	private List<PolyvQuestionChoicesVO> toPolyvQuestionChoicesVOList(List<QuestionVO.ChoicesVO> list) {
		List<PolyvQuestionChoicesVO> questionChoicesVOList = new ArrayList<>(list.size());
		for (QuestionVO.ChoicesVO choicesVO : list) {
			questionChoicesVOList.add(new PolyvQuestionChoicesVO(choicesVO.getAnswer(), choicesVO.getRightAnswer()));
		}

		return questionChoicesVOList;
	}

	/**
	 * 格式化
	 * @param body
	 * @param isFromDownload
	 * @return
	 * @throws JSONException
	 */
	@NonNull
	public static List<PolyvQuestionVO> formatQuestion(@NonNull String body, boolean isFromDownload) throws JSONException {
		JSONArray jsonArray = new JSONArray(body);
		List<PolyvQuestionVO> questionList = null;
		int length = 0;
		if (jsonArray != null && (length = jsonArray.length()) != 0) {
			questionList = new ArrayList<>(length);
			JSONObject jsonObject = null;
			JSONArray childJSONArray = null;
			List<QuestionVO.ChoicesVO> choicesList;
			PolyvQuestionVO questionVO = null;
			for (int j = 0 ; j < length ; j++) {
				jsonObject = jsonArray.getJSONObject(j);
				String examId = jsonObject.optString("examId", "");
				String userId = jsonObject.optString("userid", "");
				String vid = jsonObject.optString("videoPoolId", "");
				String showTime = jsonObject.optString("showTime", "");
				int hours = jsonObject.optInt("hours", 0);
				int minutes = jsonObject.optInt("minutes", 0);
				int seconds = jsonObject.optInt("seconds", 0);
				String question = jsonObject.optString("question", "");
				
				childJSONArray = new JSONArray(jsonObject.optString("choices"));
				int childLength = 0;
				if (childJSONArray != null && (childLength = childJSONArray.length()) != 0) {
					choicesList = new ArrayList<>(childLength);
					JSONObject childJSONObject = null;
					QuestionVO.ChoicesVO choicesVO = null;
					PolyvQuestionChoicesVO choicesVO2;
					for (int i = 0 ; i < childLength ; i++) {
						childJSONObject = childJSONArray.getJSONObject(i);
						String answer = childJSONObject.optString("answer", "");
						int rightAnswer = childJSONObject.optInt("right_answer", 0);
						choicesVO = new QuestionVO.ChoicesVO(answer, rightAnswer);
						choicesVO2 = new PolyvQuestionChoicesVO(answer, rightAnswer);
						choicesList.add(choicesVO);
					}
				} else {
					choicesList = new ArrayList<>(0);
				}
				
				String answer = jsonObject.optString("answer", "");
				boolean skip = jsonObject.optBoolean("skip", true);
				int type = jsonObject.optInt("type", 0);
				String mp3url = jsonObject.optString("mp3url", "");
				int wrongTime = jsonObject.optInt("wrongTime", -1);
				int wrongShow = jsonObject.optInt("wrongShow", 0);
				int status = jsonObject.optInt("status", 0);
				long createdTime = jsonObject.optLong("createdTime", 0L);
				questionVO = new PolyvQuestionVO(examId, userId, vid, showTime, hours, minutes, seconds, question, 
						choicesList, answer, skip, type, mp3url, wrongTime, wrongShow, status, createdTime, isFromDownload);
				questionList.add(questionVO);
			}
		} else {
			questionList = new ArrayList<>(0);
		}
		
		return questionList;
	}

	public static QuestionVO copyToQuestion(PolyvQuestionVO questionVO) {
		return new QuestionVO(questionVO.getExamId(), questionVO.getUserId(), questionVO.getVid(), questionVO.getShowTime(), questionVO.getHours(),
				questionVO.getMinutes(), questionVO.getSeconds(), questionVO.getQuestion(), questionVO.getChoicesList(), questionVO.getAnswer(), questionVO.isSkip(),
				questionVO.getType(), questionVO.getMp3url(), questionVO.getWrongTime(), questionVO.getWrongShow(), questionVO.getStatus(), questionVO.getCreatedTime(),
				questionVO.isFromDownload());
	}
}
