package com.easefun.polyvsdk.vo;

import android.support.annotation.NonNull;

import com.easefun.polyvsdk.Video;

import org.json.JSONObject;

/**
 * 广告
 * @version 2.0
 * @author TanQu 2016-3-2
 */
public class PolyvADMatterVO {
    /** 片头 */
    public static final String LOCATION_FIRST = "1";
    /** 暂停 */
    public static final String LOCATION_PAUSE = "2";
    /** 片尾 */
    public static final String LOCATION_LAST = "3";

    /** 跳转地址 */
    private final String addrUrl;
    /** 片头广告曝光监测地址 */
    private String headAdvertShowUrl;
    /** 片头广告点击检测地址 */
    private String headAdvertClickUrl;
    /** 暂停广告曝光监测地址 */
    private String stopAdvertShowUrl;
    /** 暂停广告点击检测地址 */
    private String stopAdvertClickUrl;
    /** 广告高 */
    private final int adHeight;
    private final String adId;
    /** 广告类型，1图片2视频 */
    private final int adType;
    /** 广告宽 */
    private final int adWidth;
    /** 广告id */
    private final long cataId;
    /** 位置，1是片头广告，2是暂停广告，3是片尾广告 */
    private final String location;
    /** 广告资源地址，素材有JPG，PNG，FLV，mp4类型 */
    private final String matterUrl;
    /** 广告时间 */
    private final int timeSize;
    public PolyvADMatterVO(String addrUrl, int adHeight, String adId, int adType, int adWidth, long cataId, String location,
                           String matterUrl, int timeSize) {
        super();
        this.addrUrl = addrUrl;
        this.adHeight = adHeight;
        this.adId = adId;
        this.adType = adType;
        this.adWidth = adWidth;
        this.cataId = cataId;
        this.location = location;
        this.matterUrl = matterUrl;
        this.timeSize = timeSize;
    }

    /**
     * 获取跳转地址
     * @return 跳转地址
     */
    public String getAddrUrl() {
        return addrUrl;
    }

    /**
     * 获取广告高
     * @return 高
     */
    public int getAdHeight() {
        return adHeight;
    }
    public String getAdId() {
        return adId;
    }

    /**
     * 获取广告类型，1图片2视频
     * @return 广告类型
     */
    public int getAdType() {
        return adType;
    }

    /**
     * 获取广告宽
     * @return 宽
     */
    public int getAdWidth() {
        return adWidth;
    }

    /**
     * 获取广告id
     * @return 广告id
     */
    public long getCataId() {
        return cataId;
    }

    /**
     * 获取位置，1是片头广告，2是暂停广告，3是片尾广告
     * @return 本类定义常常量
     */
    public String getLocation() {
        return location;
    }

    /**
     * 获取广告资源地址，素材有JPG，PNG，FLV，mp4类型
     * @return 广告资源地址
     */
    public String getMatterUrl() {
        return matterUrl;
    }

    /**
     * 获取广告时间，播放的时长
     * @return 时长
     */
    public int getTimeSize() {
        return timeSize;
    }
    public String getHeadAdvertShowUrl() {
        return headAdvertShowUrl;
    }
    public void setHeadAdvertShowUrl(String headAdvertShowUrl) {
        this.headAdvertShowUrl = headAdvertShowUrl;
    }
    public String getHeadAdvertClickUrl() {
        return headAdvertClickUrl;
    }
    public void setHeadAdvertClickUrl(String headAdvertClickUrl) {
        this.headAdvertClickUrl = headAdvertClickUrl;
    }
    public String getStopAdvertShowUrl() {
        return stopAdvertShowUrl;
    }
    public void setStopAdvertShowUrl(String stopAdvertShowUrl) {
        this.stopAdvertShowUrl = stopAdvertShowUrl;
    }
    public String getStopAdvertClickUrl() {
        return stopAdvertClickUrl;
    }
    public void setStopAdvertClickUrl(String stopAdvertClickUrl) {
        this.stopAdvertClickUrl = stopAdvertClickUrl;
    }
    @NonNull
    public static PolyvADMatterVO fromJSONObject(@NonNull JSONObject jsonObject) {
        String addrUrl = jsonObject.optString("addrurl", "");
        int adHeight = jsonObject.optInt("adheight", 0);
        String adId = jsonObject.optString("adid", "");
        int adType = jsonObject.optInt("adtype", 0);
        int adWidth = jsonObject.optInt("adwidth", 0);
        long cataId = jsonObject.optLong("cataid", 0);
        String location = jsonObject.optString("location", "");
        String matterUrl = jsonObject.optString("matterurl", "");
        int timeSize = jsonObject.optInt("timesize", 0);
        return new PolyvADMatterVO(addrUrl, adHeight, adId, adType, adWidth, cataId, location, matterUrl, timeSize);
    }

    public static Video.ADMatter copyToADMatter(@NonNull PolyvADMatterVO adMatterVO) {
        return new Video.ADMatter(adMatterVO.getAddrUrl(), adMatterVO.getAdHeight(), adMatterVO.getAdId(), adMatterVO.getAdType(),
                adMatterVO.getAdWidth(), adMatterVO.getCataId(), adMatterVO.getLocation(), adMatterVO.getMatterUrl(), adMatterVO.getTimeSize());
    }
}
