package com.easefun.polyvsdk.video;

import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementCountDownListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementEventListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementEventListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementOutListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementOutListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnBufferingUpdateListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnBufferingUpdateListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnCompletionListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnCompletionListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnErrorListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnErrorListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureClickListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureLeftDownListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureLeftUpListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureRightDownListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureRightUpListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureSwipeLeftListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureSwipeRightListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnInfoListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnInfoListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnPlayPauseListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnPreloadPlayListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnPreparedListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnPreparedListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnQuestionAnswerTipsListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnQuestionOutListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnQuestionOutListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnSeekCompleteListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnSeekCompleteListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnTeaserCountDownListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnTeaserOutListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoPlayErrorListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoPlayErrorListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoSRTListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoSizeChangedListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoSizeChangedListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoStatusListener;

import tv.danmaku.ijk.media.player.IMediaPlayer;

/**
 * 监听事件设置接口
 * @author TanQu 2016-12-2
 */
public interface IPolyvVideoViewListenerEvent {
    /**
     * 设置视频缓存更新回调<br/>
     * 因为 {@link IPolyvOnBufferingUpdateListener} 回调方法中第一个参数对于外部并没有提供什么帮助，避免造成多余困扰，请使用 {@link #setOnBufferingUpdateListener(IPolyvOnBufferingUpdateListener2)}
     * @param l
     * @see #setOnBufferingUpdateListener(IPolyvOnBufferingUpdateListener2)
     */
    @Deprecated
    void setOnBufferingUpdateListener(IPolyvOnBufferingUpdateListener l);
    /**
     * 设置视频缓存更新回调
     * @param l
     */
    void setOnBufferingUpdateListener(IPolyvOnBufferingUpdateListener2 l);
    /**
     * 设置视频播放/暂停/播放完成回调
     * @param l
     */
    void setOnPlayPauseListener(IPolyvOnPlayPauseListener l);
    /**
     * 设置预加载播放回调
     * @param l
     */
    void setOnPreloadPlayListener(IPolyvOnPreloadPlayListener l);
    /**
     * 设置视频非播放器内部错误回调
     * @see #setOnVideoPlayErrorListener(IPolyvOnVideoPlayErrorListener)
     * @param l
     */
    @Deprecated
    void setOnVideoPlayErrorLisener(IPolyvOnVideoPlayErrorListener l);
    /**
     * 设置视频非播放器内部错误回调
     * @see #setOnVideoPlayErrorListener(IPolyvOnVideoPlayErrorListener2)
     * @param l
     */
    @Deprecated
    void setOnVideoPlayErrorListener(IPolyvOnVideoPlayErrorListener l);
    /**
     * 设置视频非播放器内部错误回调
     * @param l
     */
    void setOnVideoPlayErrorListener(IPolyvOnVideoPlayErrorListener2 l);
    /**
     * 设置视频状态回调
     * @param l
     */
    void setOnVideoStatusListener(IPolyvOnVideoStatusListener l);
    /**
     * 设置视频播放完成回调<br/>
     * 因为 {@link IPolyvOnCompletionListener} 回调方法中第一个参数对于外部并没有提供什么帮助，避免造成多余困扰，请使用 {@link #setOnCompletionListener(IPolyvOnCompletionListener2)}
     * @param l
     * @see #setOnCompletionListener(IPolyvOnCompletionListener2)
     */
    @Deprecated
    public void setOnCompletionListener(IPolyvOnCompletionListener l);
    /**
     * 设置视频播放完成回调
     * @param l
     */
    public void setOnCompletionListener(IPolyvOnCompletionListener2 l);
    /**
     * 设置视频已准备好马上进入播放回调<br/>
     * 因为 {@link IPolyvOnPreparedListener} 回调方法中第一个参数对于外部并没有提供什么帮助，避免造成多余困扰，请使用 {@link #setOnPreparedListener(IPolyvOnPreparedListener2)}
     * @param l
     * @see #setOnPreparedListener(IPolyvOnPreparedListener2)
     */
    @Deprecated
    public void setOnPreparedListener(IPolyvOnPreparedListener l);
    /**
     * 设置视频已准备好马上进入播放回调
     * @param l
     */
    public void setOnPreparedListener(IPolyvOnPreparedListener2 l);
    /**
     * 设置视频播放器内部错误回调<br/>
     * 因为 {@link IPolyvOnErrorListener} 回调方法中第一个参数对于外部并没有提供什么帮助，避免造成多余困扰，请使用 {@link #setOnErrorListener(IPolyvOnErrorListener2)}
     * @param l
     * @see #setOnErrorListener(IPolyvOnErrorListener2)
     */
    @Deprecated
    public void setOnErrorListener(IPolyvOnErrorListener l);
    /**
     * 设置视频播放器内部错误回调
     * @param l
     */
    public void setOnErrorListener(IPolyvOnErrorListener2 l);
    /**
     * 设置视频播放器信息有变更回调<br/>
     * 因为 {@link IPolyvOnInfoListener} 回调方法中第一个参数对于外部并没有提供什么帮助，避免造成多余困扰，请使用 {@link #setOnInfoListener(IPolyvOnInfoListener2)}
     * @param l
     * @see #setOnInfoListener(IPolyvOnInfoListener2)
     */
    @Deprecated
    public void setOnInfoListener(IPolyvOnInfoListener l);
    /**
     * 设置视频播放器信息有变更回调
     * @param l
     */
    public void setOnInfoListener(IPolyvOnInfoListener2 l);
    /**
     * 设置seek完成回调<br/>
     * 因为 {@link IPolyvOnSeekCompleteListener} 回调方法中第一个参数对于外部并没有提供什么帮助，避免造成多余困扰，请使用 {@link #setOnSeekCompleteListener(IPolyvOnSeekCompleteListener2)}
     * @param l
     * @see #setOnSeekCompleteListener(IPolyvOnSeekCompleteListener2)
     */
    @Deprecated
    public void setOnSeekCompleteListener(IPolyvOnSeekCompleteListener l);
    /**
     * 设置seek完成回调
     * @param l
     */
    public void setOnSeekCompleteListener(IPolyvOnSeekCompleteListener2 l);
    /**
     * 设置视频尺寸改变回调<br/>
     * 因为 {@link IPolyvOnVideoSizeChangedListener} 回调方法中第一个参数对于外部并没有提供什么帮助，避免造成多余困扰，请使用 {@link #setOnVideoSizeChangedListener(IPolyvOnVideoSizeChangedListener2)}
     * @param l
     * @see #setOnVideoSizeChangedListener(IPolyvOnVideoSizeChangedListener2)
     */
    @Deprecated
    public void setOnVideoSizeChangedListener(IPolyvOnVideoSizeChangedListener l);
    /**
     * 设置视频尺寸改变回调
     * @param l
     */
    public void setOnVideoSizeChangedListener(IPolyvOnVideoSizeChangedListener2 l);
    /**
     * 设置广告弹出监听回调
     * @param l
     * @see #setOnAdvertisementOutListener(IPolyvOnAdvertisementOutListener2)
     */
    @Deprecated
    public void setOnAdvertisementOutListener(IPolyvOnAdvertisementOutListener l);
    /**
     * 设置广告弹出监听回调
     * @param l
     */
    public void setOnAdvertisementOutListener(IPolyvOnAdvertisementOutListener2 l);
    /**
     * 设置广告倒计时监听回调
     * @param l
     */
    public void setOnAdvertisementCountDownListener(IPolyvOnAdvertisementCountDownListener l);
    /**
     * 设置视频广告显示/点击监听回调
     * @param l
     * @see #setOnAdvertisementEventListener(IPolyvOnAdvertisementEventListener2)
     */
    @Deprecated
    public void setOnAdvertisementEventListener(IPolyvOnAdvertisementEventListener l);
    /**
     * 设置视频广告显示/点击监听回调
     * @param l
     */
    public void setOnAdvertisementEventListener(IPolyvOnAdvertisementEventListener2 l);
    /**
     * 设置片头弹出监听回调
     * @param l
     */
    public void setOnTeaserOutListener(IPolyvOnTeaserOutListener l);

    /**
     * 设置片头倒计时监听回调
     * @param l
     */
    public void setOnTeaserCountDownListener(IPolyvOnTeaserCountDownListener l);
    /**
     * 设置问答弹出监听回调，告诉此时应该弹出问答
     * @param l
     * @see #setOnQuestionOutListener(IPolyvOnQuestionOutListener2)
     */
    @Deprecated
    public void setOnQuestionOutListener(IPolyvOnQuestionOutListener l);
    /**
     * 设置问答弹出监听回调，告诉此时应该弹出问答
     * @param l
     */
    public void setOnQuestionOutListener(IPolyvOnQuestionOutListener2 l);
    /**
     * 设置问答答错提示监听回调，告诉此时应该弹出提示
     * @param l
     */
    public void setOnQuestionAnswerTipsListener(IPolyvOnQuestionAnswerTipsListener l);
    /**
     * 设置字幕监听回调
     * @param l
     */
    public void setOnVideoSRTListener(IPolyvOnVideoSRTListener l);

    /**
     * 设置手势左向上回调
     * @param l
     */
    public void setOnGestureLeftUpListener(IPolyvOnGestureLeftUpListener l);

    /**
     * 设置手势左向下回调
     * @param l
     */
    public void setOnGestureLeftDownListener(IPolyvOnGestureLeftDownListener l);

    /**
     * 设置手势右向上回调
     * @param l
     */
    public void setOnGestureRightUpListener(IPolyvOnGestureRightUpListener l);

    /**
     * 设置手势右向下回调
     * @param l
     */
    public void setOnGestureRightDownListener(IPolyvOnGestureRightDownListener l);

    /**
     * 设置手势左滑回调
     * @param l
     */
    public void setOnGestureSwipeLeftListener(IPolyvOnGestureSwipeLeftListener l);

    /**
     * 设置手势右滑回调
     * @param l
     */
    public void setOnGestureSwipeRightListener(IPolyvOnGestureSwipeRightListener l);

    /**
     * 设置手势单击回调
     * @param l
     */
    public void setOnGestureClickListener(IPolyvOnGestureClickListener l);

    /**
     * 设置视频播放完成回调<br/>
     * 因为 {@link IMediaPlayer.OnCompletionListener} 回调方法中第一个参数对于外部并没有提供什么帮助，避免造成多余困扰，请使用 {@link #setOnCompletionListener(IPolyvOnCompletionListener)}
     * @param l
     * @see #setOnCompletionListener(IPolyvOnCompletionListener)
     */
    @Deprecated
    public void setOnCompletionListener(IMediaPlayer.OnCompletionListener l);
    /**
     * 设置视频播放器内部错误回调<br/>
     * 因为 {@link IMediaPlayer.OnErrorListener} 回调方法中第一个参数对于外部并没有提供什么帮助，避免造成多余困扰，请使用 {@link #setOnErrorListener(IPolyvOnErrorListener)}
     * @param l
     * @see #setOnErrorListener(IPolyvOnErrorListener)
     */
    @Deprecated
    public void setOnErrorListener(IMediaPlayer.OnErrorListener l);
    /**
     * 设置视频播放器信息有变更回调<br/>
     * 因为 {@link IMediaPlayer.OnInfoListener} 回调方法中第一个参数对于外部并没有提供什么帮助，避免造成多余困扰，请使用 {@link #setOnInfoListener(IPolyvOnInfoListener)}
     * @param l
     * @see #setOnInfoListener(IPolyvOnInfoListener)
     */
    @Deprecated
    public void setOnInfoListener(IMediaPlayer.OnInfoListener l);
    /**
     * 设置视频已准备好马上进入播放回调<br/>
     * 因为 {@link IMediaPlayer.OnPreparedListener} 回调方法中第一个参数对于外部并没有提供什么帮助，避免造成多余困扰，请使用 {@link #setOnPreparedListener(IPolyvOnPreparedListener)}
     * @param l
     * @see #setOnPreparedListener(IPolyvOnPreparedListener)
     */
    @Deprecated
    public void setOnPreparedListener(IMediaPlayer.OnPreparedListener l);
    /**
     * 设置视频缓存更新回调<br/>
     * 因为 {@link IMediaPlayer.OnBufferingUpdateListener} 回调方法中第一个参数对于外部并没有提供什么帮助，避免造成多余困扰，请使用 {@link #setOnBufferingUpdateListener(IPolyvOnBufferingUpdateListener)}
     * @param l
     * @see #setOnBufferingUpdateListener(IPolyvOnBufferingUpdateListener)
     */
    @Deprecated
    public void setOnBufferingUpdateListener(IMediaPlayer.OnBufferingUpdateListener l);
}
