package com.easefun.polyvsdk.video;

import com.easefun.polyvsdk.ijk.IjkBaseMediaController;

/**
 * 播放器控制器
 * @version 2.0
 * @author TanQu 2015-12-11
 */
public interface IPolyvMediaController extends IMediaController {
	/**
	 * 设置播放器，在播放器中主动调用，或者播放器更新时主动调用
	 * @param player
	 */
	void setMediaPlayer(IPolyvVideoView player);
	/**
	 * 设置播放器，在播放器中主动调用，或者播放器更新时主动调用，请使用{@link #setMediaPlayer(IPolyvVideoView)}方法，
	 * {@link #setMediaPlayer(IjkBaseMediaController.MediaPlayerControl)}方法和{@link #setMediaPlayer(IPolyvVideoView)}方法会同时调用，使用其中一个就可以了。
	 * @param player
	 * @see #setMediaPlayer(IPolyvVideoView)
	 */
	@Deprecated
	void setMediaPlayer(IjkBaseMediaController.MediaPlayerControl player);
	/**
	 * 设置视图的码率，用于视图上面显示码率按钮
	 * @param vid 当前播放视频id
	 * @param bitRate 当前播放视频的码率
	 */
	void setViewBitRate(String vid, int bitRate);
	/**
	 * 释放，播放器release时主动调用
	 */
	void release();
	/**
	 * 销毁，播放器destroy时主动调用
	 */
	void destroy();
}
