package com.easefun.polyvsdk.ijk;

import android.support.annotation.IntDef;

import com.easefun.polyvsdk.ijk.widget.media.IRenderView;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * 银幕大小
 * @version 2.0
 * @author TanQu 2015-12-11
 */
public class PolyvPlayerScreenRatio {
	/** 比例缩放 */
	public static final int AR_ASPECT_FIT_PARENT = IRenderView.AR_ASPECT_FIT_PARENT;
	/** 充满父窗 */
	public static final int AR_ASPECT_FILL_PARENT = IRenderView.AR_ASPECT_FILL_PARENT;
	/** 匹配内容 */
	public static final int AR_ASPECT_WRAP_CONTENT = IRenderView.AR_ASPECT_WRAP_CONTENT;
	/** 16:9比例缩放 */
	public static final int AR_16_9_FIT_PARENT = IRenderView.AR_16_9_FIT_PARENT;
	/** 4:3比例缩放 */
	public static final int AR_4_3_FIT_PARENT = IRenderView.AR_4_3_FIT_PARENT;

	/**
	 * 自动缩放 see {@link #AR_ASPECT_FIT_PARENT}
	 */
	@Deprecated
	public static final int VIDEO_LAYOUT_ORIGIN = AR_ASPECT_FIT_PARENT;
	/**
	 * 自动缩放 see {@link #AR_ASPECT_FIT_PARENT}
	 */
	@Deprecated
	public static final int VIDEO_LAYOUT_SCALE = AR_ASPECT_FIT_PARENT;
	/**
	 * 铺满屏幕 see {@link #AR_ASPECT_FILL_PARENT}
	 */
	@Deprecated
	public static final int VIDEO_LAYOUT_STRETCH = AR_ASPECT_FILL_PARENT;
	/**
	 * 自动缩放 see {@link #AR_ASPECT_FIT_PARENT}
	 */
	@Deprecated
	public static final int VIDEO_LAYOUT_ZOOM = AR_ASPECT_FIT_PARENT;
	/**
	 * 自动缩放 see {@link #AR_ASPECT_FIT_PARENT}
	 */
	@Deprecated
	public static final int VIDEO_LAYOUT_AUTO_FIT = AR_ASPECT_FIT_PARENT;

	/** @hide */
	@IntDef({
			AR_ASPECT_FIT_PARENT,
			AR_ASPECT_FILL_PARENT,
			AR_ASPECT_WRAP_CONTENT,
			AR_16_9_FIT_PARENT,
			AR_4_3_FIT_PARENT
	})
	@Retention(RetentionPolicy.SOURCE)
	public @interface RenderScreenRatio {}
}
