/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;
import pl.droidsonroids.gif.GifImageSpan;
import pl.droidsonroids.gif.GifSpanChangeWatcher;
import pl.droidsonroids.gif.GifTextView;

public class GifSpanTextView
extends GifTextView {
    private GifSpanChangeWatcher mGifSpanChangeWatcher;

    public GifSpanTextView(Context context) {
        super(context);
        this.initGifSpanChangeWatcher();
    }

    public GifSpanTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initGifSpanChangeWatcher();
    }

    public GifSpanTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initGifSpanChangeWatcher();
    }

    private void initGifSpanChangeWatcher() {
        this.mGifSpanChangeWatcher = new GifSpanChangeWatcher((Drawable.Callback)this);
        this.addTextChangedListener(this.mGifSpanChangeWatcher);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        int i;
        int count1;
        int count;
        GifImageSpan[] spans;
        Spannable sp;
        type = TextView.BufferType.EDITABLE;
        CharSequence oldText = this.getText();
        if (!TextUtils.isEmpty((CharSequence)oldText) && oldText instanceof Spannable) {
            sp = (Spannable)oldText;
            spans = (GifImageSpan[])sp.getSpans(0, sp.length(), GifImageSpan.class);
            count = spans.length;
            for (int i2 = 0; i2 < count; ++i2) {
                spans[i2].getDrawable().setCallback(null);
            }
            GifSpanChangeWatcher[] watchers = (GifSpanChangeWatcher[])sp.getSpans(0, sp.length(), GifSpanChangeWatcher.class);
            count1 = watchers.length;
            for (i = 0; i < count1; ++i) {
                sp.removeSpan((Object)watchers[i]);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)text) && text instanceof Spannable) {
            sp = (Spannable)text;
            spans = (GifImageSpan[])sp.getSpans(0, sp.length(), GifImageSpan.class);
            count = spans.length;
            for (int i3 = 0; i3 < count; ++i3) {
                spans[i3].getDrawable().setCallback((Drawable.Callback)this);
            }
            GifSpanChangeWatcher[] watchers = (GifSpanChangeWatcher[])sp.getSpans(0, sp.length(), GifSpanChangeWatcher.class);
            count1 = watchers.length;
            for (i = 0; i < count1; ++i) {
                sp.removeSpan((Object)watchers[i]);
            }
            if (this.mGifSpanChangeWatcher == null) {
                this.mGifSpanChangeWatcher = new GifSpanChangeWatcher((Drawable.Callback)this);
            }
            sp.setSpan((Object)this.mGifSpanChangeWatcher, 0, text.length(), 6553618);
        }
        super.setText(text, type);
    }

    private GifImageSpan getImageSpan(Drawable drawable) {
        Spanned spanned;
        GifImageSpan[] spans;
        GifImageSpan imageSpan = null;
        CharSequence text = this.getText();
        if (!TextUtils.isEmpty((CharSequence)text) && text instanceof Spanned && (spans = (GifImageSpan[])(spanned = (Spanned)text).getSpans(0, text.length(), GifImageSpan.class)) != null && spans.length > 0) {
            for (GifImageSpan span : spans) {
                if (drawable != span.getDrawable()) continue;
                imageSpan = span;
            }
        }
        return imageSpan;
    }

    public void invalidateDrawable(Drawable drawable) {
        GifImageSpan imageSpan = this.getImageSpan(drawable);
        if (imageSpan != null) {
            CharSequence text = this.getText();
            if (!TextUtils.isEmpty((CharSequence)text) && text instanceof Editable) {
                Editable editable = (Editable)text;
                int start = editable.getSpanStart((Object)imageSpan);
                int end = editable.getSpanEnd((Object)imageSpan);
                int flags = editable.getSpanFlags((Object)imageSpan);
                editable.removeSpan((Object)imageSpan);
                editable.setSpan((Object)imageSpan, start, end, flags);
            }
        } else {
            super.invalidateDrawable(drawable);
        }
    }
}

