/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.service.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.eaglesakura.android.service.data.ParcelablePayload;
import com.eaglesakura.util.CollectionUtil;
import java.util.HashMap;
import java.util.Map;

public final class Payload
implements Parcelable {
    private byte[] mBuffer = null;
    private final Map<String, byte[]> mExtraBuffers = new HashMap<String, byte[]>();
    private final Map<String, ParcelablePayload> mExtraParcelable = new HashMap<String, ParcelablePayload>();
    private static final int SERIALIZE_MAIN_BUFFER = 1;
    private static final int SERIALIZE_EXTRA_BUFFER = 2;
    private static final int SERIALIZE_EXTRA_PARCERCELABLE = 4;
    public static final Parcelable.Creator<Payload> CREATOR = new Parcelable.Creator<Payload>(){

        public Payload createFromParcel(Parcel source) {
            return new Payload(source);
        }

        public Payload[] newArray(int size) {
            return new Payload[size];
        }
    };

    public static Payload fromString(String str) {
        if (str != null) {
            return new Payload(str.getBytes());
        }
        return new Payload((byte[])null);
    }

    public Payload(byte[] buffer) {
        if (buffer != null) {
            this.mBuffer = buffer;
        }
    }

    public byte[] getBuffer() {
        return this.mBuffer;
    }

    public Payload put(String key, byte[] buffer) {
        this.mExtraBuffers.put(key, buffer);
        return this;
    }

    public Payload put(String key, Parcelable data) {
        this.mExtraParcelable.put(key, new ParcelablePayload(data));
        return this;
    }

    public byte[] getBuffer(String key) {
        return this.mExtraBuffers.get(key);
    }

    public <T extends Parcelable> T getParcelable(String key) {
        ParcelablePayload payload = this.mExtraParcelable.get(key);
        if (payload == null) {
            return null;
        }
        return (T)payload.data;
    }

    public int describeContents() {
        return 0;
    }

    public static String deserializeStringOrNull(Payload payload) {
        if (payload != null && payload.getBuffer() != null) {
            return new String(payload.getBuffer());
        }
        return null;
    }

    public void writeToParcel(Parcel dest, int flags) {
        int serializeFlags = 0;
        if (!CollectionUtil.isEmpty((byte[])this.mBuffer)) {
            serializeFlags |= 1;
        }
        if (!this.mExtraBuffers.isEmpty()) {
            serializeFlags |= 2;
        }
        if (!this.mExtraParcelable.isEmpty()) {
            serializeFlags |= 4;
        }
        dest.writeInt(serializeFlags);
        if ((serializeFlags & 1) != 0) {
            dest.writeByteArray(this.mBuffer);
        }
        if ((serializeFlags & 2) != 0) {
            dest.writeInt(this.mExtraBuffers.size());
            for (Map.Entry<String, byte[]> entry : this.mExtraBuffers.entrySet()) {
                dest.writeString(entry.getKey());
                dest.writeByteArray(entry.getValue());
            }
        }
        if ((serializeFlags & 4) != 0) {
            dest.writeInt(this.mExtraParcelable.size());
            for (Map.Entry<String, Object> entry : this.mExtraParcelable.entrySet()) {
                dest.writeString(entry.getKey());
                ((ParcelablePayload)entry.getValue()).writeToParcel(dest, flags);
            }
        }
    }

    protected Payload(Parcel in) {
        String key;
        int i;
        int size;
        int serializeFlags = in.readInt();
        if ((serializeFlags & 1) != 0) {
            this.mBuffer = in.createByteArray();
        }
        if ((serializeFlags & 2) != 0) {
            size = in.readInt();
            for (i = 0; i < size; ++i) {
                key = in.readString();
                this.mExtraBuffers.put(key, in.createByteArray());
            }
        }
        if ((serializeFlags & 4) != 0) {
            size = in.readInt();
            for (i = 0; i < size; ++i) {
                key = in.readString();
                ParcelablePayload pp = (ParcelablePayload)ParcelablePayload.CREATOR.createFromParcel(in);
                this.mExtraParcelable.put(key, pp);
            }
        }
    }
}

