/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.WorkerThread;
import com.eaglesakura.android.service.aidl.ICommandClientCallback;
import com.eaglesakura.android.service.aidl.ICommandServerService;
import com.eaglesakura.android.service.data.Payload;
import com.eaglesakura.android.thread.UIHandler;
import com.eaglesakura.android.util.AndroidThreadUtil;
import com.eaglesakura.lambda.CallbackUtils;
import com.eaglesakura.lambda.CancelCallback;
import com.eaglesakura.util.StringUtil;

public abstract class CommandClient {
    protected final Context mContext;
    private ICommandServerService server;
    private final String id;
    private ServiceConnection connection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, final IBinder service) {
            UIHandler.postUIorRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    ICommandServerService newServer = ICommandServerService.Stub.asInterface(service);
                    try {
                        newServer.registerCallback(CommandClient.this.id, CommandClient.this.callback);
                    }
                    catch (RemoteException e) {
                        throw new IllegalStateException(e);
                    }
                    CommandClient.this.server = newServer;
                    CommandClient.this.onConnected();
                }
            });
        }

        public void onServiceDisconnected(ComponentName name) {
            UIHandler.postUIorRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (CommandClient.this.server != null) {
                        CommandClient.this.server = null;
                        CommandClient.this.onDisconnected(1);
                    }
                }
            });
        }
    };
    private ICommandClientCallback callback = new ICommandClientCallback.Stub(){

        @Override
        public Payload postToClient(String cmd, Payload payload) throws RemoteException {
            return CommandClient.this.onReceivedData(cmd, payload);
        }
    };
    public static final int FLAG_DISCONNECT_CRASH_SERVER = 1;

    public CommandClient(Context context) {
        this.mContext = context.getApplicationContext();
        this.id = context.getPackageName() + "@" + this.getClass().getName();
    }

    public String getId() {
        return this.id;
    }

    public CommandClient(Context context, String uid) {
        if (!StringUtil.isEmpty((String)uid)) {
            if (uid.indexOf(64) >= 0) {
                throw new IllegalArgumentException();
            }
        } else {
            uid = this.getClass().getName();
        }
        this.mContext = context.getApplicationContext();
        this.id = context.getPackageName() + "@" + uid;
    }

    public boolean isConnected() {
        return this.server != null;
    }

    protected ICommandServerService getServer() {
        return this.server;
    }

    protected void connectToSever(Intent intent) {
        AndroidThreadUtil.assertUIThread();
        if (this.server != null) {
            return;
        }
        this.mContext.bindService(intent, this.connection, 1);
    }

    @WorkerThread
    protected boolean connectToSever(final Intent intent, CancelCallback cancelCallback) {
        if (!UIHandler.postWithWait((Runnable)new Runnable(){

            @Override
            public void run() {
                CommandClient.this.connectToSever(intent);
            }
        }, (CancelCallback)cancelCallback)) {
            return false;
        }
        while (!this.isConnected()) {
            if (!CallbackUtils.isCanceled((CancelCallback)cancelCallback)) continue;
            UIHandler.postUI((Runnable)new Runnable(){

                @Override
                public void run() {
                    CommandClient.this.disconnect();
                }
            });
            return false;
        }
        return true;
    }

    public void disconnect() {
        AndroidThreadUtil.assertUIThread();
        if (this.server == null) {
            return;
        }
        try {
            this.server.unregisterCallback(this.callback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mContext.unbindService(this.connection);
        this.server = null;
        this.onDisconnected(0);
    }

    @WorkerThread
    public boolean disconnect(CancelCallback cancelCallback) {
        return UIHandler.postWithWait((Runnable)new Runnable(){

            @Override
            public void run() {
                CommandClient.this.disconnect();
            }
        }, (CancelCallback)cancelCallback);
    }

    public Payload requestPostToServer(String cmd, Payload payload) throws RemoteException {
        if (this.server == null) {
            throw new IllegalStateException("Server not connected");
        }
        return this.server.postToServer(cmd, this.id, payload);
    }

    protected Payload onReceivedData(String cmd, Payload payload) throws RemoteException {
        return null;
    }

    protected void onConnected() {
    }

    @Deprecated
    protected void onDisconnected() {
    }

    protected void onDisconnected(int flags) {
        this.onDisconnected();
    }
}

