/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera.spec;

import android.content.Context;
import com.eaglesakura.android.util.ContextUtil;
import com.eaglesakura.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class FocusMode {
    private static final Map<String, FocusMode> gFocusModeSpecMap = new HashMap<String, FocusMode>();
    public static final FocusMode SETTING_AUTO = FocusMode.fromName("auto");
    public static final FocusMode SETTING_INFINITY = FocusMode.fromName("infinity");
    public static final FocusMode SETTING_MACRO = FocusMode.fromName("macro");
    public static final FocusMode SETTING_CONTINUOUS_PICTURE = FocusMode.fromName("continuous-picture");
    public static final FocusMode SETTING_CONTINUOUS_VIDEO = FocusMode.fromName("continuous-video");
    private final String mName;

    FocusMode(String apiSettingName) {
        this.mName = apiSettingName;
    }

    public String name(Context context) {
        String result = ContextUtil.getStringFromIdName((Context)context, (String)String.format("Camera.FocusMode.%s", this.mName.replaceAll("-", "_")));
        if (StringUtil.isEmpty((String)result)) {
            return this.mName;
        }
        return result;
    }

    public String getRawName() {
        return this.mName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FocusMode focusMode = (FocusMode)o;
        return this.mName != null ? this.mName.equals(focusMode.mName) : focusMode.mName == null;
    }

    public int hashCode() {
        return this.mName != null ? this.mName.hashCode() : 0;
    }

    public static FocusMode fromName(String mode) {
        FocusMode result = gFocusModeSpecMap.get(mode);
        if (result == null) {
            result = new FocusMode(mode);
            gFocusModeSpecMap.put(mode, result);
        }
        return result;
    }
}

