/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera;

import android.content.Context;
import android.hardware.Camera;
import android.support.annotation.NonNull;
import com.eaglesakura.android.camera.CameraSpec;
import com.eaglesakura.android.camera.error.CameraAccessFailedException;
import com.eaglesakura.android.camera.error.CameraException;
import com.eaglesakura.android.camera.error.CameraNotFoundException;
import com.eaglesakura.android.camera.spec.CameraType;
import com.eaglesakura.android.camera.spec.CaptureSize;
import com.eaglesakura.android.camera.spec.FlashMode;
import com.eaglesakura.android.camera.spec.FocusMode;
import com.eaglesakura.android.camera.spec.Scene;
import com.eaglesakura.android.camera.spec.WhiteBalance;
import com.eaglesakura.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CameraLegacySpecImpl {
    Camera mCamera;
    Camera.Parameters parameters;
    static final Map<CameraType, CameraSpec> sSpecCache = new HashMap<CameraType, CameraSpec>();

    public CameraLegacySpecImpl(Context context, Camera camera) throws CameraException {
        this.mCamera = camera;
        if (this.mCamera == null) {
            throw new CameraAccessFailedException();
        }
        this.parameters = this.mCamera.getParameters();
    }

    static int getCameraNumber(CameraType type) throws CameraException {
        int cameras = Camera.getNumberOfCameras();
        for (int i = 0; i < cameras; ++i) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (type == CameraType.Front && info.facing == 1) {
                return i;
            }
            if (type != CameraType.Back || info.facing != 0) continue;
            return i;
        }
        if (cameras > 0 && (type == CameraType.External || type == CameraType.Auto)) {
            return 0;
        }
        throw new CameraNotFoundException("Type:" + (Object)((Object)type));
    }

    @NonNull
    static List<CaptureSize> getPreviewSizes(Camera.Parameters parameters) throws CameraException {
        ArrayList<CaptureSize> result = new ArrayList<CaptureSize>();
        for (Camera.Size size : parameters.getSupportedPreviewSizes()) {
            result.add(new CaptureSize(size.width, size.height));
        }
        return result;
    }

    @NonNull
    static List<CaptureSize> getPictureSizes(Camera.Parameters parameters) throws CameraException {
        ArrayList<CaptureSize> result = new ArrayList<CaptureSize>();
        for (Camera.Size size : parameters.getSupportedPictureSizes()) {
            result.add(new CaptureSize(size.width, size.height));
        }
        return result;
    }

    @NonNull
    static List<Scene> getScenes(Camera.Parameters parameters) {
        ArrayList<Scene> result = new ArrayList<Scene>();
        Util.ifPresent((Object)parameters.getSupportedSceneModes(), it -> {
            for (String mode : it) {
                result.add(Scene.fromName(mode));
            }
        });
        return result;
    }

    @NonNull
    static List<FlashMode> getFlashModes(Camera.Parameters parameters) {
        ArrayList<FlashMode> result = new ArrayList<FlashMode>();
        Util.ifPresent((Object)parameters.getSupportedFlashModes(), it -> {
            for (String mode : it) {
                result.add(FlashMode.fromName(mode));
            }
        });
        return result;
    }

    @NonNull
    static List<FocusMode> getFocusModes(Camera.Parameters parameters) {
        ArrayList<FocusMode> result = new ArrayList<FocusMode>();
        Util.ifPresent((Object)parameters.getSupportedFocusModes(), it -> {
            for (String mode : it) {
                result.add(FocusMode.fromName(mode));
            }
        });
        return result;
    }

    @NonNull
    static List<WhiteBalance> getWhiteBalances(Camera.Parameters parameters) {
        ArrayList<WhiteBalance> result = new ArrayList<WhiteBalance>();
        Util.ifPresent((Object)parameters.getSupportedWhiteBalance(), it -> {
            for (String mode : it) {
                result.add(WhiteBalance.fromName(mode));
            }
        });
        return result;
    }

    static CameraSpec getSpecs(Context context, CameraType type) throws CameraException {
        CameraSpec spec = sSpecCache.get((Object)type);
        if (spec == null) {
            throw new CameraNotFoundException("type : " + (Object)((Object)type));
        }
        return spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        for (CameraType type : CameraType.values()) {
            Camera camera = null;
            try {
                int number = CameraLegacySpecImpl.getCameraNumber(type);
                camera = Camera.open((int)number);
                Camera.Parameters params = camera.getParameters();
                CameraSpec spec = new CameraSpec(type);
                spec.mFlashModeSpecs = CameraLegacySpecImpl.getFlashModes(params);
                spec.mFocusModeSpecs = CameraLegacySpecImpl.getFocusModes(params);
                spec.mJpegPictureSize = CameraLegacySpecImpl.getPictureSizes(params);
                spec.mRawPictureSize = new ArrayList<CaptureSize>();
                spec.mPreviewSizes = CameraLegacySpecImpl.getPreviewSizes(params);
                spec.mSceneSpecs = CameraLegacySpecImpl.getScenes(params);
                spec.mWhiteBalanceSpecs = CameraLegacySpecImpl.getWhiteBalances(params);
                sSpecCache.put(type, spec);
            }
            catch (Exception exception) {
            }
            finally {
                if (camera != null) {
                    try {
                        camera.release();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

