/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera.spec;

import android.content.Context;
import com.eaglesakura.android.util.ContextUtil;
import com.eaglesakura.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class WhiteBalance {
    private static final Map<String, WhiteBalance> gWhiteBalanceSpecMap = new HashMap<String, WhiteBalance>();
    public static final WhiteBalance SETTING_AUTO = WhiteBalance.fromName("auto");
    public static final WhiteBalance SETTING_INCANDESCENT = WhiteBalance.fromName("incandescent");
    public static final WhiteBalance SETTING_FLUORESCENT = WhiteBalance.fromName("fluorescent");
    public static final WhiteBalance SETTING_DAYLIGHT = WhiteBalance.fromName("daylight");
    public static final WhiteBalance SETTING_CLOUDY_DAYLIGHT = WhiteBalance.fromName("cloudy-daylight");
    private final String mName;

    WhiteBalance(String apiSettingName) {
        this.mName = apiSettingName;
    }

    public String name(Context context) {
        String result = ContextUtil.getStringFromIdName((Context)context, (String)String.format("Camera.WhiteBalance.%s", this.mName.replaceAll("-", "_")));
        if (StringUtil.isEmpty((String)result)) {
            return this.mName;
        }
        return result;
    }

    public String getRawName() {
        return this.mName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WhiteBalance)) {
            return false;
        }
        return ((WhiteBalance)o).mName.equals(this.mName);
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public static WhiteBalance fromName(String mode) {
        WhiteBalance result = gWhiteBalanceSpecMap.get(mode);
        if (result == null) {
            result = new WhiteBalance(mode);
            gWhiteBalanceSpecMap.put(mode, result);
        }
        return result;
    }

    public static List<WhiteBalance> list(List<String> deviceSettings) {
        ArrayList<WhiteBalance> result = new ArrayList<WhiteBalance>();
        if (deviceSettings == null) {
            return result;
        }
        for (String mode : deviceSettings) {
            result.add(WhiteBalance.fromName(mode));
        }
        return result;
    }
}

