/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera.spec;

import android.content.Context;
import com.eaglesakura.android.util.ContextUtil;
import com.eaglesakura.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class FlashMode {
    private static final Map<String, FlashMode> gFlashSpecMap = new HashMap<String, FlashMode>();
    public static final FlashMode SETTING_AUTO = FlashMode.fromName("auto");
    public static final FlashMode SETTING_OFF = FlashMode.fromName("off");
    public static final FlashMode SETTING_ON = FlashMode.fromName("on");
    public static final FlashMode SETTING_RED_EYE = FlashMode.fromName("red-eye");
    public static final FlashMode SETTING_TORCH = FlashMode.fromName("torch");
    private final String mName;
    private final boolean mPermitFlash;

    FlashMode(String apiSettingName) {
        this.mName = apiSettingName;
        this.mPermitFlash = !apiSettingName.toLowerCase().equals("off");
    }

    public boolean isPermitFlash() {
        return this.mPermitFlash;
    }

    public String getRawName() {
        return this.mName;
    }

    public String name(Context context) {
        String result = ContextUtil.getStringFromIdName((Context)context, (String)String.format("Camera.FlashMode.%s", this.mName.replaceAll("-", "_")));
        if (StringUtil.isEmpty((String)result)) {
            return this.mName;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlashMode flashMode = (FlashMode)o;
        return this.mName != null ? this.mName.equals(flashMode.mName) : flashMode.mName == null;
    }

    public int hashCode() {
        return this.mName != null ? this.mName.hashCode() : 0;
    }

    public static FlashMode fromName(String mode) {
        FlashMode result = gFlashSpecMap.get(mode);
        if (result == null) {
            result = new FlashMode(mode);
            gFlashSpecMap.put(mode, result);
        }
        return result;
    }
}

