/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera;

import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import com.eaglesakura.android.camera.spec.CaptureFormat;
import com.eaglesakura.android.camera.spec.CaptureSize;

public final class CameraPictureShotRequest {
    private double mLatitude;
    private double mLongitude;
    @NonNull
    private CaptureFormat mCaptureFormat = CaptureFormat.Jpeg;
    private final CaptureSize mCaptureSize;

    public CameraPictureShotRequest(@NonNull CaptureSize size) {
        this.mCaptureSize = size;
    }

    public CameraPictureShotRequest location(double lat, double lng) {
        this.mLatitude = lat;
        this.mLongitude = lng;
        return this;
    }

    @FloatRange(from=-90.0, to=90.0)
    public double getLatitude() {
        return this.mLatitude;
    }

    @FloatRange(from=-180.0, to=180.0)
    public double getLongitude() {
        return this.mLongitude;
    }

    public boolean hasLocation() {
        return this.mLatitude != 0.0 && this.mLongitude != 0.0;
    }

    public CameraPictureShotRequest captureFormat(CaptureFormat fmt) {
        this.mCaptureFormat = fmt;
        return this;
    }

    public CaptureSize getCaptureSize() {
        return this.mCaptureSize;
    }

    @NonNull
    public CaptureFormat getCaptureFormat() {
        return this.mCaptureFormat;
    }
}

