/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera.spec;

import com.eaglesakura.util.MathUtil;

public class Orientation {
    private final int degree;
    public static final Orientation ROTATE_0 = new Orientation(0);
    public static final Orientation ROTATE_90 = new Orientation(90);
    public static final Orientation ROTATE_180 = new Orientation(180);
    public static final Orientation ROTATE_270 = new Orientation(270);

    private Orientation(int rotateDegree) {
        this.degree = rotateDegree;
    }

    public int getDegree() {
        return this.degree;
    }

    public boolean isVertical() {
        return this.degree == 90 || this.degree == 180;
    }

    public boolean isHorizontal() {
        return !this.isVertical();
    }

    public static final Orientation fromDegree(int rotate) {
        rotate = (int)MathUtil.normalizeDegree((float)rotate);
        rotate = rotate / 90 * 90;
        switch (rotate) {
            case 0: {
                return ROTATE_0;
            }
            case 90: {
                return ROTATE_90;
            }
            case 180: {
                return ROTATE_180;
            }
            case 270: {
                return ROTATE_270;
            }
        }
        throw new IllegalStateException(String.format("Rotate error(%d)", rotate));
    }
}

