/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera.preview;

import android.graphics.SurfaceTexture;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.Surface;
import com.eaglesakura.android.camera.spec.CaptureSize;

public class CameraSurface {
    private Surface mNativeSurface;
    private SurfaceTexture mSurfaceTexture;

    public CameraSurface(SurfaceTexture surfaceTexture) {
        this.mSurfaceTexture = surfaceTexture;
    }

    public CameraSurface(Surface nativeSurface) {
        this.mNativeSurface = nativeSurface;
    }

    @NonNull
    public Surface getNativeSurface(CaptureSize previewSize) {
        if (this.mSurfaceTexture != null) {
            if (Build.VERSION.SDK_INT >= 15) {
                this.mSurfaceTexture.setDefaultBufferSize(previewSize.getWidth(), previewSize.getHeight());
            }
            if (this.mNativeSurface == null) {
                this.mNativeSurface = new Surface(this.mSurfaceTexture);
            }
        }
        if (this.mNativeSurface == null) {
            throw new NullPointerException("mNativeSurface == null");
        }
        return this.mNativeSurface;
    }

    @NonNull
    public SurfaceTexture getSurfaceTexture(CaptureSize previewSize) {
        if (this.mSurfaceTexture != null && Build.VERSION.SDK_INT >= 15) {
            this.mSurfaceTexture.setDefaultBufferSize(previewSize.getWidth(), previewSize.getHeight());
        }
        return this.mSurfaceTexture;
    }
}

