/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import com.eaglesakura.android.camera.Camera2SpecImpl;
import com.eaglesakura.android.camera.CameraApi;
import com.eaglesakura.android.camera.CameraLegacySpecImpl;
import com.eaglesakura.android.camera.CameraSpec$$Lambda$1;
import com.eaglesakura.android.camera.CameraSpec$$Lambda$2;
import com.eaglesakura.android.camera.CameraSpec$$Lambda$3;
import com.eaglesakura.android.camera.error.CameraException;
import com.eaglesakura.android.camera.error.CameraSpecNotFoundException;
import com.eaglesakura.android.camera.spec.CameraType;
import com.eaglesakura.android.camera.spec.CaptureSize;
import com.eaglesakura.android.camera.spec.FlashMode;
import com.eaglesakura.android.camera.spec.FocusMode;
import com.eaglesakura.android.camera.spec.Scene;
import com.eaglesakura.android.camera.spec.WhiteBalance;
import com.eaglesakura.math.Vector2;
import com.eaglesakura.util.CollectionUtil;
import java.util.Collections;
import java.util.List;

public class CameraSpec {
    List<CaptureSize> mPreviewSizes;
    List<CaptureSize> mJpegPictureSize;
    List<CaptureSize> mRawPictureSize;
    List<Scene> mSceneSpecs;
    List<WhiteBalance> mWhiteBalanceSpecs;
    List<FocusMode> mFocusModeSpecs;
    List<FlashMode> mFlashModeSpecs;
    final CameraType mType;

    CameraSpec(CameraType type) {
        this.mType = type;
    }

    CameraSpec init() {
        Collections.sort(this.mJpegPictureSize, CameraSpec$$Lambda$1.lambdaFactory$());
        Collections.sort(this.mRawPictureSize, CameraSpec$$Lambda$2.lambdaFactory$());
        Collections.sort(this.mPreviewSizes, CameraSpec$$Lambda$3.lambdaFactory$());
        return this;
    }

    @NonNull
    public CameraType getType() {
        return this.mType;
    }

    public Vector2 getViewSize(int minWidth, int minHeight, CaptureSize size) {
        Vector2 result = new Vector2((float)minWidth, (float)minHeight);
        result.x = (float)((double)minHeight * size.getAspect());
        if ((int)result.x < minWidth) {
            result.x = minWidth;
            result.y = (float)((double)minWidth / size.getAspect());
        }
        return result;
    }

    @NonNull
    public List<CaptureSize> getPreviewSizes() {
        return this.mPreviewSizes;
    }

    @NonNull
    public CaptureSize getPreviewSize(int requireWidth, int requireHeight) {
        return this.chooseShotSize(this.mPreviewSizes, requireWidth, requireHeight, requireWidth, requireHeight);
    }

    @NonNull
    public CaptureSize getMinimumPreviewSize() {
        return this.mPreviewSizes.get(this.mPreviewSizes.size() - 1);
    }

    @NonNull
    public CaptureSize getJpegPictureSize(CaptureSize.Aspect aspect) {
        for (CaptureSize size : this.mJpegPictureSize) {
            if (size.getAspectType() != aspect) continue;
            return size;
        }
        return this.mJpegPictureSize.get(0);
    }

    @NonNull
    public CaptureSize getFullJpegPictureSize() {
        return this.mJpegPictureSize.get(0);
    }

    @NonNull
    public CaptureSize getJpegPictureSize(int requireWidth, int requireHeight) {
        return this.chooseShotSize(this.mJpegPictureSize, requireWidth, requireHeight, requireWidth, requireHeight);
    }

    public boolean isSupportedScene(Scene scene) {
        return this.mSceneSpecs.contains(scene);
    }

    @NonNull
    public List<Scene> getSceneSpecs() {
        return this.mSceneSpecs;
    }

    public boolean isSupported(Scene scene) {
        return this.mSceneSpecs.contains(scene);
    }

    public boolean isSupported(WhiteBalance whiteBalance) {
        return this.mWhiteBalanceSpecs.contains(whiteBalance);
    }

    public boolean isSupported(FlashMode flashMode) {
        return this.mFlashModeSpecs.contains(flashMode);
    }

    public boolean isSupported(FocusMode focusMode) {
        return this.mFocusModeSpecs.contains(focusMode);
    }

    @NonNull
    public List<WhiteBalance> getWhiteBalanceSpecs() {
        return this.mWhiteBalanceSpecs;
    }

    @NonNull
    public List<CaptureSize> getJpegPictureSizes() {
        return this.mJpegPictureSize;
    }

    @NonNull
    public List<CaptureSize> getRawPictureSizes() {
        return this.mRawPictureSize;
    }

    @NonNull
    public List<FlashMode> getFlashModeSpecs() {
        return this.mFlashModeSpecs;
    }

    @NonNull
    public List<FocusMode> getFocusModeSpecs() {
        return this.mFocusModeSpecs;
    }

    public boolean hasFlash() {
        return !CollectionUtil.isEmpty(this.mFlashModeSpecs);
    }

    private CaptureSize chooseShotSize(List<CaptureSize> targetSizes, int width, int height, int minWidth, int minHeight) {
        float reqLargeValue = Math.max(width, height);
        float reqSmallValue = Math.min(width, height);
        float lowerSizeLarge = Math.max(minWidth, minHeight);
        float lowerSizeSmall = Math.min(minWidth, minHeight);
        float TARGET_ASPECT = Math.max(1.0f, reqLargeValue) / Math.max(1.0f, reqSmallValue);
        CaptureSize target = targetSizes.get(0);
        try {
            float current_diff = 1.0E9f;
            for (CaptureSize size : targetSizes) {
                float aspect_diff;
                float checkLargeValue = Math.max(size.getWidth(), size.getHeight());
                float checkSmallValue = Math.min(size.getWidth(), size.getHeight());
                if (!(checkLargeValue >= lowerSizeLarge) || !(checkSmallValue >= lowerSizeSmall) || !(Math.abs(aspect_diff = checkLargeValue / checkSmallValue - TARGET_ASPECT) <= current_diff)) continue;
                target = size;
                current_diff = aspect_diff;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return target;
    }

    @NonNull
    public CaptureSize getPreviewSize(String id) throws CameraException {
        for (CaptureSize size : this.mPreviewSizes) {
            if (!size.getId().equals(id)) continue;
            return size;
        }
        throw new CameraSpecNotFoundException(id);
    }

    @NonNull
    public CaptureSize getJpegPictureSize(String id) throws CameraException {
        for (CaptureSize size : this.mJpegPictureSize) {
            if (!size.getId().equals(id)) continue;
            return size;
        }
        throw new CameraSpecNotFoundException(id);
    }

    @NonNull
    public CaptureSize getRawPictureSize(String id) throws CameraException {
        for (CaptureSize size : this.mRawPictureSize) {
            if (!size.getId().equals(id)) continue;
            return size;
        }
        throw new CameraSpecNotFoundException(id);
    }

    public static CameraSpec getSpecs(Context context, CameraApi api, CameraType type) throws CameraException {
        if (api.equals((Object)CameraApi.Default)) {
            api = Build.VERSION.SDK_INT >= 21 ? CameraApi.Camera2 : CameraApi.Legacy;
        }
        if (api == CameraApi.Camera2) {
            return Camera2SpecImpl.getSpecs(context, type);
        }
        return CameraLegacySpecImpl.getSpecs(context, type);
    }

    public static CameraSpec getSpecs(Context context, CameraType type) throws CameraException {
        return CameraSpec.getSpecs(context, CameraApi.Default, type);
    }

    static /* synthetic */ int lambda$init$8(CaptureSize a, CaptureSize b) {
        return -Double.compare(a.getMegaPixel(), b.getMegaPixel());
    }

    static /* synthetic */ int lambda$init$7(CaptureSize a, CaptureSize b) {
        return -Double.compare(a.getMegaPixel(), b.getMegaPixel());
    }

    static /* synthetic */ int lambda$init$6(CaptureSize a, CaptureSize b) {
        return -Double.compare(a.getMegaPixel(), b.getMegaPixel());
    }
}

