/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera;

import android.support.annotation.Nullable;
import com.eaglesakura.android.camera.CameraSpec;
import com.eaglesakura.android.camera.spec.FlashMode;
import com.eaglesakura.android.camera.spec.FocusMode;
import com.eaglesakura.android.camera.spec.Scene;
import com.eaglesakura.android.camera.spec.WhiteBalance;

public final class CameraEnvironmentRequest {
    @Nullable
    FocusMode mFocusMode;
    @Nullable
    Scene mScene;
    @Nullable
    WhiteBalance mWhiteBalance;
    @Nullable
    FlashMode mFlashMode;

    public CameraEnvironmentRequest focus(FocusMode focusMode) {
        this.mFocusMode = focusMode;
        return this;
    }

    public CameraEnvironmentRequest focus(CameraSpec spec, FocusMode focusMode) {
        if (spec.isSupported(focusMode)) {
            this.mFocusMode = focusMode;
        }
        return this;
    }

    public CameraEnvironmentRequest scene(Scene scene) {
        this.mScene = scene;
        return this;
    }

    public CameraEnvironmentRequest scene(CameraSpec spec, Scene scene) {
        if (spec.isSupported(scene)) {
            this.mScene = scene;
        }
        return this;
    }

    public CameraEnvironmentRequest whiteBalance(WhiteBalance whiteBalance) {
        this.mWhiteBalance = whiteBalance;
        return this;
    }

    public CameraEnvironmentRequest whiteBalance(CameraSpec spec, WhiteBalance whiteBalance) {
        if (spec.isSupported(whiteBalance)) {
            this.mWhiteBalance = whiteBalance;
        }
        return this;
    }

    public CameraEnvironmentRequest flash(FlashMode flashMode) {
        this.mFlashMode = flashMode;
        return this;
    }

    public CameraEnvironmentRequest flash(CameraSpec spec, FlashMode flashMode) {
        if (spec.isSupported(flashMode)) {
            this.mFlashMode = flashMode;
        }
        return this;
    }

    @Nullable
    public FlashMode getFlashMode() {
        return this.mFlashMode;
    }

    @Nullable
    public FocusMode getFocusMode() {
        return this.mFocusMode;
    }

    @Nullable
    public Scene getScene() {
        return this.mScene;
    }

    @Nullable
    public WhiteBalance getWhiteBalance() {
        return this.mWhiteBalance;
    }
}

