/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.location.Location;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.Surface;
import com.eaglesakura.android.camera.Camera2ControlManager$$Lambda$1;
import com.eaglesakura.android.camera.Camera2ControlManager$$Lambda$2;
import com.eaglesakura.android.camera.Camera2ControlManager$$Lambda$3;
import com.eaglesakura.android.camera.Camera2ControlManager$$Lambda$4;
import com.eaglesakura.android.camera.Camera2ControlManager$$Lambda$5;
import com.eaglesakura.android.camera.Camera2ControlManager$$Lambda$6;
import com.eaglesakura.android.camera.Camera2SpecImpl;
import com.eaglesakura.android.camera.CameraApi;
import com.eaglesakura.android.camera.CameraConnectRequest;
import com.eaglesakura.android.camera.CameraControlManager;
import com.eaglesakura.android.camera.CameraEnvironmentRequest;
import com.eaglesakura.android.camera.CameraPictureShotRequest;
import com.eaglesakura.android.camera.CameraPreviewRequest;
import com.eaglesakura.android.camera.PictureData;
import com.eaglesakura.android.camera.error.CameraAccessFailedException;
import com.eaglesakura.android.camera.error.CameraException;
import com.eaglesakura.android.camera.error.CameraSecurityException;
import com.eaglesakura.android.camera.error.PictureFailedException;
import com.eaglesakura.android.camera.log.CameraLog;
import com.eaglesakura.android.camera.preview.CameraSurface;
import com.eaglesakura.android.camera.spec.CameraType;
import com.eaglesakura.android.camera.spec.CaptureFormat;
import com.eaglesakura.android.camera.spec.FocusMode;
import com.eaglesakura.android.thread.AsyncHandler;
import com.eaglesakura.android.util.AndroidThreadUtil;
import com.eaglesakura.android.util.ContextUtil;
import com.eaglesakura.thread.Holder;
import com.eaglesakura.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;

@TargetApi(value=21)
public class Camera2ControlManager
extends CameraControlManager {
    final Camera2SpecImpl mSpec;
    final CameraCharacteristics mCharacteristics;
    @NonNull
    private CameraDevice mCamera;
    private CameraCaptureSession mCaptureSession;
    private CaptureRequest.Builder mPreviewCaptureRequest;
    private CameraSurface mPreviewSurface;
    private ImageReader mImageReader;
    private AsyncHandler mControlHandler;
    private AsyncHandler mProcessingHandler;
    private AsyncHandler mTaskQueue;
    private CameraPreviewRequest mPreviewRequest;
    private CameraPictureShotRequest mPictureShotRequest;
    private static final int FLAG_NOW_PREVIEW = 1;
    private int mFlags;

    Camera2ControlManager(Context context, CameraConnectRequest request) throws CameraException {
        super(context, request);
        this.mSpec = new Camera2SpecImpl(context);
        this.mCharacteristics = this.mSpec.getCameraSpec(request.getCameraType());
    }

    @Override
    @NonNull
    public CameraApi getSupportApi() {
        return CameraApi.Camera2;
    }

    @Override
    public boolean connect(@Nullable CameraSurface previewSurface, @Nullable CameraPreviewRequest previewRequest, @Nullable CameraPictureShotRequest shotRequest) throws CameraException {
        AndroidThreadUtil.assertBackgroundThread();
        this.mControlHandler = AsyncHandler.createInstance((String)"camera-control");
        this.mProcessingHandler = AsyncHandler.createInstance((String)"camera-processing");
        this.mTaskQueue = AsyncHandler.createInstance((String)"camera-queue");
        this.mCamera = (CameraDevice)this.mTaskQueue.await(Camera2ControlManager$$Lambda$1.lambdaFactory$(this, previewSurface, previewRequest, shotRequest));
        return true;
    }

    @Override
    public void startPreview(@Nullable CameraEnvironmentRequest env) throws CameraException {
        this.mTaskQueue.await(Camera2ControlManager$$Lambda$2.lambdaFactory$(this, env));
    }

    @Override
    public boolean isPreviewNow() {
        return (this.mFlags & 1) != 0;
    }

    @Override
    public boolean isConnected() {
        return this.mCamera != null;
    }

    @Override
    public void disconnect() {
        AndroidThreadUtil.assertBackgroundThread();
        this.mTaskQueue.await(Camera2ControlManager$$Lambda$3.lambdaFactory$(this));
        this.mControlHandler.dispose();
        this.mProcessingHandler.dispose();
        this.mTaskQueue.dispose();
        this.mControlHandler = null;
        this.mProcessingHandler = null;
        this.mTaskQueue = null;
    }

    private int getJpegOrientation() {
        int sensorOrientation = (Integer)this.mCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        int deviceRotateDegree = ContextUtil.getDeviceRotateDegree((Context)this.mContext);
        deviceRotateDegree = this.mConnectRequest.getCameraType() == CameraType.Back ? (360 - sensorOrientation + deviceRotateDegree) % 360 : (sensorOrientation + deviceRotateDegree + 360) % 360;
        return deviceRotateDegree;
    }

    private CaptureRequest.Builder newCaptureRequest(CameraEnvironmentRequest env, int template) throws CameraAccessException {
        CaptureRequest.Builder request = this.mCamera.createCaptureRequest(template);
        if (env != null) {
            if (env.getFlashMode() != null) {
                request.set(CaptureRequest.FLASH_MODE, (Object)Camera2SpecImpl.toFlashModeInt(env.getFlashMode()));
            }
            if (env.getFocusMode() != null) {
                FocusMode mode = env.getFocusMode();
                if (mode == FocusMode.SETTING_INFINITY) {
                    request.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(0.0f));
                }
                request.set(CaptureRequest.CONTROL_AF_MODE, (Object)Camera2SpecImpl.toAeModeInt(mode));
            }
            if (env.getScene() != null) {
                request.set(CaptureRequest.CONTROL_SCENE_MODE, (Object)Camera2SpecImpl.toSceneInt(env.getScene()));
            }
            if (env.getWhiteBalance() != null) {
                request.set(CaptureRequest.CONTROL_AWB_MODE, (Object)Camera2SpecImpl.toAwbInt(env.getWhiteBalance()));
            }
        }
        return request;
    }

    @NonNull
    private CameraCaptureSession getSession() throws CameraException {
        if (this.mCaptureSession != null) {
            return this.mCaptureSession;
        }
        ArrayList<Surface> surfaces = new ArrayList<Surface>();
        if (this.mPreviewRequest != null) {
            surfaces.add(this.mPreviewSurface.getNativeSurface(this.mPreviewRequest.getPreviewSize()));
        }
        if (this.mPictureShotRequest != null) {
            this.mImageReader = ImageReader.newInstance((int)this.mPictureShotRequest.getCaptureSize().getWidth(), (int)this.mPictureShotRequest.getCaptureSize().getHeight(), (int)(this.mPictureShotRequest.getCaptureFormat() == CaptureFormat.Raw ? 32 : 256), (int)2);
            surfaces.add(this.mImageReader.getSurface());
        }
        final Holder errorHolder = new Holder();
        final Holder sessionHolder = new Holder();
        try {
            this.mCamera.createCaptureSession(surfaces, new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession session) {
                    sessionHolder.set((Object)session);
                }

                public void onConfigureFailed(CameraCaptureSession session) {
                    errorHolder.set((Object)new CameraException("Session create failed"));
                }
            }, (Handler)this.mControlHandler);
        }
        catch (CameraAccessException e) {
            throw new CameraAccessFailedException(e);
        }
        while (errorHolder.get() == null && sessionHolder.get() == null) {
            Util.sleep((long)1L);
        }
        if (errorHolder.get() != null) {
            throw (CameraException)errorHolder.get();
        }
        this.mCaptureSession = (CameraCaptureSession)sessionHolder.get();
        return this.mCaptureSession;
    }

    private void startPreviewImpl(@Nullable CameraEnvironmentRequest env) throws CameraException {
        try {
            CameraCaptureSession previewSession = this.getSession();
            if (this.mPreviewCaptureRequest == null) {
                CaptureRequest.Builder builder = this.newCaptureRequest(env, 1);
                builder.addTarget(this.mPreviewSurface.getNativeSurface(this.mPreviewRequest.getPreviewSize()));
                this.mPreviewCaptureRequest = builder;
            }
            previewSession.stopRepeating();
            previewSession.setRepeatingRequest(this.mPreviewCaptureRequest.build(), null, null);
            this.mFlags |= 1;
        }
        catch (CameraAccessException e) {
            throw new CameraAccessFailedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPreviewImpl() {
        Camera2ControlManager camera2ControlManager = this;
        synchronized (camera2ControlManager) {
            try {
                if (this.mCaptureSession != null) {
                    this.mCaptureSession.stopRepeating();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mFlags &= 0xFFFFFFFE;
        }
    }

    @Override
    public final void stopPreview() {
        this.mTaskQueue.await(Camera2ControlManager$$Lambda$4.lambdaFactory$(this));
    }

    private void startPreCapture(CameraCaptureSession session, Surface imageSurface, @Nullable CameraEnvironmentRequest env) throws CameraException, CameraAccessException {
        CaptureRequest.Builder builder = this.newCaptureRequest(env, 1);
        builder.addTarget(imageSurface);
        builder.set(CaptureRequest.JPEG_ORIENTATION, (Object)this.getJpegOrientation());
        builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        builder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        final Holder errorHolder = new Holder();
        final Holder completedHolder = new Holder();
        session.stopRepeating();
        session.capture(builder.build(), new CameraCaptureSession.CaptureCallback(){

            public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
                Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                CameraLog.hardware("onCaptureCompleted :: pre-capture", new Object[0]);
                CameraLog.hardware("  - AE State :: " + aeState, new Object[0]);
                completedHolder.set((Object)Boolean.TRUE);
            }

            public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
                errorHolder.set((Object)new PictureFailedException("PreCapture Failed"));
            }
        }, (Handler)this.mControlHandler);
        while (errorHolder.get() == null && completedHolder.get() == null) {
            Util.sleep((long)1L);
        }
        if (errorHolder.get() != null) {
            throw (CameraException)errorHolder.get();
        }
    }

    PictureData takePictureImpl(@Nullable CameraEnvironmentRequest env) throws CameraException {
        if (this.mPreviewRequest != null && !this.isPreviewNow()) {
            throw new IllegalStateException("Preview not started");
        }
        CameraCaptureSession session = this.getSession();
        try {
            if (this.mPreviewRequest != null) {
                this.startPreCapture(session, this.mPreviewSurface.getNativeSurface(this.mPreviewRequest.getPreviewSize()), env);
            }
            final Holder errorHolder = new Holder();
            Holder resultHolder = new Holder();
            final Holder captureCompletedHolder = new Holder();
            CameraCaptureSession.CaptureCallback captureCallback = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
                    captureCompletedHolder.set((Object)Boolean.TRUE);
                }

                public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
                    errorHolder.set((Object)new PictureFailedException("Fail :: " + failure.getReason()));
                }
            };
            this.mImageReader.setOnImageAvailableListener(Camera2ControlManager$$Lambda$5.lambdaFactory$(this, resultHolder), (Handler)this.mProcessingHandler);
            CaptureRequest.Builder builder = this.newCaptureRequest(env, 2);
            builder.set(CaptureRequest.JPEG_ORIENTATION, (Object)this.getJpegOrientation());
            if (this.mPictureShotRequest.hasLocation()) {
                Location loc = new Location("camera");
                loc.setLatitude(this.mPictureShotRequest.getLatitude());
                loc.setLongitude(this.mPictureShotRequest.getLongitude());
                builder.set(CaptureRequest.JPEG_GPS_LOCATION, (Object)loc);
            }
            builder.addTarget(this.mImageReader.getSurface());
            session.stopRepeating();
            session.capture(builder.build(), captureCallback, (Handler)this.mControlHandler);
            while (errorHolder.get() == null && resultHolder.get() == null) {
                Util.sleep((long)1L);
            }
            if (errorHolder.get() != null) {
                throw (CameraException)errorHolder.get();
            }
            while (captureCompletedHolder.get() == null) {
                Util.sleep((long)1L);
            }
            PictureData pictureData = (PictureData)resultHolder.get();
            return pictureData;
        }
        catch (CameraAccessException e) {
            throw new CameraAccessFailedException(e);
        }
        finally {
            this.mImageReader.setOnImageAvailableListener(null, null);
            if ((this.mFlags & 1) != 0) {
                this.startPreviewImpl(env);
            }
        }
    }

    @Override
    public final PictureData takePicture(@Nullable CameraEnvironmentRequest env) throws CameraException {
        return (PictureData)this.mTaskQueue.await(Camera2ControlManager$$Lambda$6.lambdaFactory$(this, env));
    }

    static /* synthetic */ PictureData lambda$takePicture$5(Camera2ControlManager this_, CameraEnvironmentRequest cameraEnvironmentRequest) throws CameraException {
        return this_.takePictureImpl(cameraEnvironmentRequest);
    }

    static /* synthetic */ void lambda$takePictureImpl$4(Camera2ControlManager this_, Holder holder, ImageReader it) {
        Image image = this_.mImageReader.acquireLatestImage();
        ByteBuffer buffer = image.getPlanes()[0].getBuffer();
        byte[] onMemoryFile = new byte[buffer.capacity()];
        buffer.get(onMemoryFile);
        holder.set((Object)new PictureData(image.getWidth(), image.getHeight(), onMemoryFile));
        image.close();
    }

    static /* synthetic */ Camera2ControlManager lambda$stopPreview$3(Camera2ControlManager this_) throws RuntimeException {
        this_.stopPreviewImpl();
        return this_;
    }

    static /* synthetic */ Camera2ControlManager lambda$disconnect$2(Camera2ControlManager this_) throws RuntimeException {
        if (!this_.isConnected()) {
            throw new IllegalStateException("not conencted");
        }
        try {
            this_.stopPreviewImpl();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this_.mImageReader != null) {
            this_.mImageReader.close();
            this_.mImageReader = null;
        }
        try {
            this_.mCamera.close();
            this_.mCamera = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this_;
    }

    static /* synthetic */ Camera2ControlManager lambda$startPreview$1(Camera2ControlManager this_, CameraEnvironmentRequest cameraEnvironmentRequest) throws CameraException {
        this_.startPreviewImpl(cameraEnvironmentRequest);
        return this_;
    }

    static /* synthetic */ CameraDevice lambda$connect$0(Camera2ControlManager this_, CameraSurface cameraSurface, CameraPreviewRequest cameraPreviewRequest, CameraPictureShotRequest cameraPictureShotRequest) throws CameraException {
        this_.mPreviewSurface = cameraSurface;
        this_.mPreviewRequest = cameraPreviewRequest;
        this_.mPictureShotRequest = cameraPictureShotRequest;
        final Holder errorHolder = new Holder();
        final Holder cameraDeviceHolder = new Holder();
        try {
            this_.mSpec.getCameraManager().openCamera(this_.mSpec.getCameraId(), new CameraDevice.StateCallback(){

                public void onOpened(CameraDevice camera) {
                    cameraDeviceHolder.set((Object)camera);
                    CameraLog.hardware("onOpened[%s]", camera.getId());
                }

                public void onDisconnected(CameraDevice camera) {
                    CameraLog.hardware("onDisconnected[%s]", camera.getId());
                    camera.close();
                    Camera2ControlManager.this.mCamera = null;
                }

                public void onError(CameraDevice camera, int error) {
                    errorHolder.set((Object)new CameraSecurityException("Error :: " + error));
                    camera.close();
                    Camera2ControlManager.this.mCamera = null;
                }
            }, (Handler)this_.mControlHandler);
            while (errorHolder.get() == null && cameraDeviceHolder.get() == null) {
                Util.sleep((long)1L);
            }
            if (errorHolder.get() != null) {
                throw (CameraException)errorHolder.get();
            }
            return (CameraDevice)cameraDeviceHolder.get();
        }
        catch (CameraAccessException e) {
            throw new CameraAccessFailedException(e);
        }
        catch (SecurityException e) {
            throw new CameraSecurityException(e);
        }
    }
}

