/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera.spec;

import android.content.Context;
import com.eaglesakura.android.util.ContextUtil;
import com.eaglesakura.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Scene {
    private final String mName;
    private static final Map<String, Scene> gSceneSpecMap = new HashMap<String, Scene>();
    public static final Scene SETTING_AUTO = Scene.fromName("auto");
    public static final Scene SETTING_PORTRAIT = Scene.fromName("portrait");
    public static final Scene SETTING_LANDSCAPE = Scene.fromName("landscape");
    public static final Scene SETTING_NIGHT = Scene.fromName("night");
    public static final Scene SETTING_NIGHT_PORTRAIT = Scene.fromName("night-portrait");
    public static final Scene SETTING_BEACH = Scene.fromName("beach");
    public static final Scene SETTING_SNOW = Scene.fromName("snow");
    public static final Scene SETTING_SPORTS = Scene.fromName("sports");
    public static final Scene SETTING_PARTY = Scene.fromName("party");
    public static final Scene SETTING_DOCUMENT = Scene.fromName("document");

    Scene(String apiSettingName) {
        this.mName = apiSettingName;
    }

    public String name(Context context) {
        String result = ContextUtil.getStringFromIdName((Context)context, (String)String.format("Camera.Scene.%s", this.mName.replaceAll("-", "_")));
        if (StringUtil.isEmpty((String)result)) {
            return this.mName;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Scene)) {
            return false;
        }
        return ((Scene)o).mName.equals(this.mName);
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String getRawName() {
        return this.mName;
    }

    public static Scene fromName(String mode) {
        Scene result = gSceneSpecMap.get(mode);
        if (result == null) {
            result = new Scene(mode);
            gSceneSpecMap.put(mode, result);
        }
        return result;
    }

    public static List<Scene> list(List<String> deviceSettings) {
        ArrayList<Scene> result = new ArrayList<Scene>();
        if (deviceSettings == null) {
            return result;
        }
        for (String mode : deviceSettings) {
            result.add(Scene.fromName(mode));
        }
        return result;
    }
}

