/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.camera.spec;

import com.eaglesakura.math.Vector2;

public class CaptureSize {
    private final Vector2 mSize;
    private final Aspect mAspectID;

    public CaptureSize(int width, int height) {
        this.mSize = new Vector2((float)width, (float)height);
        this.mAspectID = Aspect.getNearAspect(this.getAspect());
    }

    public double getMegaPixel() {
        return (double)(this.mSize.x * this.mSize.y) / 1000.0 / 1000.0;
    }

    public int getWidth() {
        return (int)this.mSize.x;
    }

    public int getHeight() {
        return (int)this.mSize.y;
    }

    public String getMegaPixelText() {
        return String.format("%.1f", this.getMegaPixel());
    }

    public String getAspectText() {
        return this.mAspectID.aspectText();
    }

    public Aspect getAspectType() {
        return this.mAspectID;
    }

    public double getAspect() {
        return (double)this.getWidth() / (double)this.getHeight();
    }

    public Vector2 getViewSize(boolean flipOrientation, int minWidth, int minHeight) {
        float aspect = (float)this.getAspect();
        if (flipOrientation) {
            aspect = (float)this.getHeight() / (float)this.getWidth();
        }
        Vector2 result = new Vector2((float)minWidth, (float)minHeight);
        result.x = (float)minHeight * aspect;
        if ((int)result.x < minWidth) {
            result.x = minWidth;
            result.y = (float)minWidth / aspect;
        }
        return result;
    }

    public String getId() {
        return String.format("pic(%dx%d)", this.getWidth(), this.getHeight());
    }

    public static enum Aspect {
        WH1x1{

            @Override
            public double aspect() {
                return 1.0;
            }

            @Override
            public String aspectText() {
                return "1:1";
            }
        }
        ,
        WH3x2{

            @Override
            public double aspect() {
                return 1.5;
            }

            @Override
            public String aspectText() {
                return "3:2";
            }
        }
        ,
        WH4x3{

            @Override
            public double aspect() {
                return 1.3333333333333333;
            }

            @Override
            public String aspectText() {
                return "4:3";
            }
        }
        ,
        WH16x9{

            @Override
            public double aspect() {
                return 1.7777777777777777;
            }

            @Override
            public String aspectText() {
                return "16:9";
            }
        }
        ,
        WH16x10{

            @Override
            public double aspect() {
                return 1.6;
            }

            @Override
            public String aspectText() {
                return "16:10";
            }
        };


        public abstract double aspect();

        public abstract String aspectText();

        static Aspect getNearAspect(double aspect) {
            Aspect[] values;
            double diffNear = 9.9999999E7;
            Aspect result = null;
            for (Aspect value : values = Aspect.values()) {
                double checkDiff = Math.abs(value.aspect() - aspect);
                if (!(checkDiff < diffNear)) continue;
                result = value;
                diffNear = checkDiff;
            }
            return result;
        }
    }
}

